// const imageChatModel = require("../DataModel/ImageChatModel");
// const userModel = require("../DataModel/AuthDataModel");
// const packageModel = require("../DataModel/packageModel");
// const fs = require("fs");
// const path = require("path");
// const request = require("request");
// const OpenAI = require("openai");

// const openAiApiModel = require("../DataModel/OpenAISettingModel");

// async function getOpenAIKey() {
//   try {
//     const settings = await openAiApiModel.findOne();
//     return settings ? settings.openAiAPI : null;
//   } catch (error) {
//     console.error("Error fetching OpenAI API key:", error);
//     return null;
//   }
// }
// const userChatImage = async (req, res) => {
//   const apiKey = await getOpenAIKey();
//   const openai = new OpenAI({
//     apiKey: apiKey,
//   });
//   const { id, fileData } = req.body;
//   const email = req.headers.email;
//   try {
//     const user = await userModel.findOne({ email });
//     if (!user) {
//       return res.status(400).json({ error: "User not found" });
//     }
//     const userPackage = await packageModel.aggregate([
//       {
//         $match: {
//           packageType: user.plan,
//           packageDuration: user.packageTime,
//         },
//       },
//     ]);

//     if (!userPackage || userPackage.length === 0) {
//       return res
//         .status(500)
//         .json({ error: "User package information not found" });
//     }

//     const selectedPackage = userPackage[0];
//     if (user.apiUseChatImageLimit >= selectedPackage.chatImageLimit) {
//       return res
//         .status(402)
//         .json({ error: "Access limit exceeded for image generation" });
//     }

//     const numberOfImages = 1;
//     const UPLOAD_FOLDER = "./AllFile/ChatImage";

//     for (let i = 0; i < numberOfImages; i++) {
//       const response = await openai.images.generate({
//         model: "dall-e-3",
//         prompt: `Please give me a picture of ${fileData} and follow my instruction`,
//         size: "1024x1024",
//       });
//       const imageUrl = response.data[0].url;
//       const imagePath = `${Date.now()}_${i}.jpg`;
//       const filePath = path.join(UPLOAD_FOLDER, imagePath);
//       const file = fs.createWriteStream(filePath);
//       await new Promise((resolve, reject) => {
//         request
//           .get({ url: imageUrl })
//           .pipe(file)
//           .on("finish", resolve)
//           .on("error", reject);
//       });
//       const imageUrlSaved = `/chatImage/${imagePath}`;
//       const timestamp = new Date().toISOString();
//       const assistant = await imageChatModel.findOne({ _id: id });
//       if (!assistant) {
//         return res.status(400).json({ error: "Assistant not found" });
//       }
//       // Create a new chat message object
//       const newChatMessage = {
//         message: imageUrlSaved,
//         sender: "chatGpt",
//         sendTime: timestamp,
//         email: email,
//         inputValue: fileData,
//       };

//       assistant.last_chat.push(newChatMessage);
//       await assistant.save();

//       await userModel.findOneAndUpdate(
//         { email },
//         { $inc: { apiUseChatImageLimit: 1 } }
//       );
//     }

//     res.status(200).json({
//       success: true,
//       message: `Generated and saved ${numberOfImages} images successfully.`,
//     });
//   } catch (error) {
//     console.error(error);
//     res.status(500).json({
//       success: false,
//       error: "Failed to generate and save images",
//     });
//   }
// };
const imageChatModel = require("../DataModel/ImageChatModel");
const userModel = require("../DataModel/AuthDataModel");
const packageModel = require("../DataModel/packageModel");
const fs = require("fs");
const path = require("path");
const axios = require("axios");
const OpenAI = require("openai");

const openAiApiModel = require("../DataModel/OpenAISettingModel");

async function getOpenAIKey() {
  try {
    const settings = await openAiApiModel.findOne();
    return settings ? settings.openAiAPI : null;
  } catch (error) {
    console.error("Error fetching OpenAI API key:", error);
    return null;
  }
}

const userChatImage = async (req, res) => {
  const apiKey = await getOpenAIKey();
  const openai = new OpenAI({
    apiKey: apiKey,
  });
  const { id, fileData } = req.body;
  const email = req.headers.email;
  try {
    const user = await userModel.findOne({ email });
    if (!user) {
      return res.status(400).json({ error: "User not found" });
    }
    const userPackage = await packageModel.aggregate([
      {
        $match: {
          packageType: user.plan,
          packageDuration: user.packageTime,
        },
      },
    ]);

    if (!userPackage || userPackage.length === 0) {
      return res
        .status(500)
        .json({ error: "User package information not found" });
    }

    const selectedPackage = userPackage[0];
    if (user.apiUseChatImageLimit >= selectedPackage.chatImageLimit) {
      return res
        .status(402)
        .json({ error: "Access limit exceeded for image generation" });
    }

    const numberOfImages = 1;
    const UPLOAD_FOLDER = "./AllFile/ChatImage";

    for (let i = 0; i < numberOfImages; i++) {
      const response = await openai.images.generate({
        model: "dall-e-3",
        prompt: `Please give me a picture of ${fileData} and follow my instruction`,
        size: "1024x1024",
      });
      const imageUrl = response.data[0].url;
      const imagePath = `${Date.now()}_${i}.jpg`;
      const filePath = path.join(UPLOAD_FOLDER, imagePath);

      const imageResponse = await axios({
        url: imageUrl,
        method: "GET",
        responseType: "stream",
      });

      const writer = fs.createWriteStream(filePath);

      imageResponse.data.pipe(writer);

      await new Promise((resolve, reject) => {
        writer.on("finish", resolve);
        writer.on("error", reject);
      });

      const imageUrlSaved = `/chatImage/${imagePath}`;
      const timestamp = new Date().toISOString();
      const assistant = await imageChatModel.findOne({ _id: id });
      if (!assistant) {
        return res.status(400).json({ error: "Assistant not found" });
      }
      // Create a new chat message object
      const newChatMessage = {
        message: imageUrlSaved,
        sender: "chatGpt",
        sendTime: timestamp,
        email: email,
        inputValue: fileData,
      };

      assistant.last_chat.push(newChatMessage);
      await assistant.save();

      await userModel.findOneAndUpdate(
        { email },
        { $inc: { apiUseChatImageLimit: 1 } }
      );
    }

    res.status(200).json({
      success: true,
      message: `Generated and saved ${numberOfImages} images successfully.`,
    });
  } catch (error) {
    console.error(error);
    res.status(500).json({
      success: false,
      error: "Failed to generate and save images",
    });
  }
};


const getAllImageChatAssistantData = async (req, res) => {
  try {
    const data = await imageChatModel.find();
    res.status(200).json({ success: true, data });
  } catch (error) {
    res.status(500).json({ success: false, message: "Internal Server Error" });
  }
};

const allImageAssistantTableData = async (req, res) => {
  try {
    const email = req.headers["email"];
    const pageNo = Number(req.params.pageNo);
    const perPage = Number(req.params.perPage);
    const searchValue = req.params.searchKeyword;
    const skipRow = (pageNo - 1) * perPage;
    const searchRgx = new RegExp(searchValue, "i");
    const matchStage = [
      {
        $match: {
          $or: [{ "last_chat.message": searchRgx }],
        },
      },
      {
        $addFields: {
          createDate: {
            $toDate: "$createDate",
          },
        },
      },
    ];

    const sortStage = {
      $sort: { createDate: -1 },
    };

    const aggregationResult = await imageChatModel
      .aggregate([
        ...matchStage,
        sortStage,
        {
          $match: { "last_chat.email": email },
        },
        {
          $facet: {
            data: [{ $skip: skipRow }, { $limit: perPage }],
            total: [{ $count: "total" }],
            last_chat_matched: [
              { $unwind: "$last_chat" },
              { $match: { "last_chat.email": email } },
              {
                $group: {
                  _id: null,
                  data: { $push: "$last_chat" },
                  count: { $sum: 1 },
                },
              },
            ],
          },
        },
      ])
      .exec();
    const lastChatMatched =
      aggregationResult[0].last_chat_matched?.[0]?.data || [];
    const lastChatCount =
      aggregationResult[0].last_chat_matched?.[0]?.count || 0;

    res.status(200).json({
      status: "success",
      data: { lastChatMatched, lastChatCount },
    });
  } catch (error) {
    console.error(error);
    res
      .status(500)
      .json({ status: "failed", error: error.message, data: null });
  }
};
const deleteChatImageDocument = async (req, res) => {
  const id = req.params.id;

  try {
    const result = await imageChatModel.updateOne(
      { "last_chat._id": id },
      { $pull: { last_chat: { _id: id } } }
    );
    if (result.nModified === 0) {
      return res.status(404).json({
        status: "error",
        message: "No document found with the specified _id",
      });
    }
    res
      .status(200)
      .json({ status: "success", message: "Message deleted successfully" });
  } catch (error) {
    console.error(error);
    res
      .status(500)
      .json({ status: "failed", error: error.message, data: null });
  }
};
// chat agent Create for fonded
const createChatImageAgent = async (req, res) => {
  const { title, message } = req.body;

  try {
    const response = await imageChatModel.create({ title, message });
    res
      .status(200)
      .json({ status: "success", message: "Created successfully" });
  } catch (error) {
    console.error("Error creating chat image:", error);
    res.status(500).json({ status: "error", message: "Failed to create" });
  }
};
const updateChatImageAgent = async (req, res) => {
  const { id, title } = req.body;

  try {
    if (!id || !title) {
      return res
        .status(400)
        .json({ status: "error", message: "Missing required fields" });
    }

    const response = await imageChatModel.findOneAndUpdate(
      { _id: id },
      { title: title },
      { new: true }
    );

    if (!response) {
      return res
        .status(404)
        .json({ status: "error", message: "Image not found" });
    }

    res.status(200).json({ status: "success", message: response });
  } catch (error) {
    console.error("Error updating chat image:", error);
    res
      .status(500)
      .json({ status: "error", message: "Failed to update image" });
  }
};
const deleteChatImageAgent = async (req, res) => {
  const { id } = req.params;

  try {
    const response = await imageChatModel.deleteOne({ _id: id });
    res.status(200).json({ status: "success", message: response });
  } catch (error) {
    console.error("Error creating chat image:", error);
    res.status(500).json({ status: "error", message: "Failed to create" });
  }
};

module.exports = {
  userChatImage,
  getAllImageChatAssistantData,
  allImageAssistantTableData,
  deleteChatImageDocument,
  createChatImageAgent,
  deleteChatImageAgent,
  updateChatImageAgent,
};
