const userModel = require("../DataModel/AuthDataModel");
const packageModel = require("../DataModel/packageModel");
const OpenAI = require("openai");
const openAiApiModel = require("../DataModel/OpenAISettingModel");

// Function to asynchronously retrieve OpenAI API key
async function getOpenAIKey() {
  try {
    const settings = await openAiApiModel.findOne();
    return settings ? settings.openAiAPI : null;
  } catch (error) {
    console.error("Error fetching OpenAI API key:", error);
    return null;
  }
}
const autoCheckTextValue = async (req, res) => {
  const apiKey = await getOpenAIKey();
  const openai = new OpenAI({
    apiKey: apiKey,
  });
  const { text } = req.body;
  const email = req.headers.email;
  try {
    const user = await userModel.findOne({ email });
    if (!user) {
      return res.status(400).json({ error: "User not found" });
    }
    const response = await openai.chat.completions.create({
      model: "gpt-3.5-turbo",
      messages: [
        {
          role: "system",
          content: `you are a grammar mistake checker only.find out grammar mistake sentence.if spelling mistake then count as a sentence mistake.
           answer HTML format,mistake sentence in <h5></h5>. return only mistake sentence with list pint or serial number`,
        },
        { role: "user", content: `${text}` },
      ],
      max_tokens: 3000,
      temperature: 0.7,
      frequency_penalty: 0.4,
      presence_penalty: 0.3,
    });
    const generatedText = response.choices[0].message.content;
    res.status(200).json({ data: generatedText });
  } catch (error) {
    console.error("Error paraphrasing text:", error);
    res.status(500).json({ error: "Error paraphrasing text" });
  }
};

const fixErrorTextReq = async (req, res) => {
  const { text } = req.body;
  const email = req.headers.email;
  try {
    const user = await userModel.findOne({ email });
    if (!user) {
      return res.status(400).json({ error: "User not found" });
    }
    const userPackage = await packageModel.findOne({
      packageType: user.plan,
      packageDuration: user.packageTime,
    });

    if (!userPackage) {
      return res
        .status(500)
        .json({ error: "User package information not found" });
    }

    if (user.apiUseGrammarChekiangLimit >= userPackage.grammarChekiangLimit) {
      return res
        .status(402)
        .json({ error: "Access limit exceeded for audio generation" });
    }
    const response = await openai.chat.completions.create({
      model: "gpt-3.5-turbo",
      messages: [
        {
          role: "system",
          content: `You are a grammar mistake solver. Find out the grammar mistake and solve this. If there is a spelling mistake, 
          then count as a sentence mistake and solve it with similar word.answer HTML format only correct sentence what you solve in <h6></h6> .`,
        },
        {
          role: "user",
          content: `Just solve the grammar error. after solve the error return update text what provides the users. user text is ${text}.
        .The correct sentence set in <h6></h6>.`,
        },
      ],
      max_tokens: 3000,
      temperature: 0.7,
      frequency_penalty: 0.4,
      presence_penalty: 0.3,
    });
    const generatedText = response.choices[0].message.content;
    await userModel.findOneAndUpdate(
      { email },
      {
        $inc: {
          apiUseGrammarChekiangLimit: 1,
        },
      }
    );
    res.status(200).json({ data: generatedText });
  } catch (error) {
    console.error("Error paraphrasing text:", error);
    res.status(500).json({ error: "Error paraphrasing text" });
  }
};

module.exports = { autoCheckTextValue, fixErrorTextReq };
