const nodemailer = require("nodemailer");
const SMTPModel = require("../DataModel/SMTPModel");

const contactForm = async (req, res) => {
  try {
    const smtpData = await SMTPModel.findOne();
    let transporter = nodemailer.createTransport({
      host: smtpData.smtpHost,
      port: smtpData.smtpPort,
      secure: true,
      auth: {
        user: smtpData.smtpSenderEmail,
        pass: smtpData.smtpPassword,
      },
    });

    let mailOptions = {
      from: req.body.email,
      to: "rapidai@mernsolution.com",
      subject: `Message from ${req.body.email} - Name: ${req.body.name}`,
      text: req.body.message,
    };

    const info = await transporter.sendMail(mailOptions);

    res.status(200).json({ message: "Message sent successfully", info });

    console.log("Email sent: " + info.messageId);

    return info;
  } catch (error) {
    console.error("Error sending email:", error);
    throw error;
  }
};

module.exports = { contactForm };
