const userModel = require("../DataModel/AuthDataModel");
const packageModel = require("../DataModel/packageModel");
const OpenAI = require("openai");
const openAiApiModel = require("../DataModel/OpenAISettingModel");

// Function to asynchronously retrieve OpenAI API key
async function getOpenAIKey() {
  try {
    const settings = await openAiApiModel.findOne();
    return settings ? settings.openAiAPI : null;
  } catch (error) {
    console.error("Error fetching OpenAI API key:", error);
    return null;
  }
}

const Paraphraser = async (req, res) => {
  const apiKey = await getOpenAIKey();
  const openai = new OpenAI({
    apiKey: apiKey,
  });
  const { originalText } = req.body;
  const email = req.headers.email;
  try {
    const user = await userModel.findOne({ email });
    if (!user) {
      return res.status(400).json({ error: "User not found" });
    }

    const userPackage = await packageModel.findOne({
      packageType: user.plan,
      packageDuration: user.packageTime,
    });

    if (!userPackage) {
      return res
        .status(500)
        .json({ error: "User package information not found" });
    }

    if (user.apiUseTextParaphraser >= userPackage.aiTextParaphraser) {
      return res
        .status(402)
        .json({ error: "Access limit exceeded for audio generation" });
    }
    const response = await openai.chat.completions.create({
      model: "gpt-3.5-turbo",
      messages: [
        {
          role: "system",
          content: `You will modify 20% sentence by sentence with synonym word and phrase like Paraphraser no change meanie of text.must fallow grammar and meaning`,
        },
        { role: "user", content: `${originalText}` },
      ],
      max_tokens: 3000,
      temperature: 0.7,
      frequency_penalty: 0.4,
      presence_penalty: 0.3,
    });

    const generatedText = response.choices[0].message.content;
    await userModel.findOneAndUpdate(
      { email },
      { $inc: { apiUseTextParaphraser: 1 } }
    );
    res.status(200).json({ data: generatedText });
  } catch (error) {
    console.error("Error paraphrasing text:", error);
    res.status(500).json({ error: "Error paraphrasing text" });
  }
};

module.exports = { Paraphraser };
