const packageModel = require("../DataModel/packageModel");
const createPackage = async (req, res) => {
  const {
    title,
    packageType,
    packageDuration,
    price,
    textToImage,
    imagination,
    packageCurrency,
    imageCaption,
    freeLimit,
    chatImageLimit,
    imageAudioLimit,
    scratchToCodeLimit,
    grammarChekiangLimit,
    textToParaphraserLimit,
    aiChatAssistantLimit,
    aiTemplateLimit,
    editAudioLimit,
    videoToTextLimit,
    aiVisionLimit,
    webScriptingLimit,
    youTubeAnalyserLimit,
    aiRewriterLimit,
    speechToTextLimit,
    aiVoiceoverLimit,
    aiCodeGenerateLimit,
    selectedVIP,
    selectedPremium,
  } = req.body;

  try {
    const package = await packageModel.create({
      title,
      packageType,
      packageDuration,
      price,
      textToImage,
      imagination,
      packageCurrency,
      imageCaption,
      freeLimit,
      chatImageLimit,
      imageAudioLimit,
      scratchToCodeLimit,
      grammarChekiangLimit,
      textToParaphraserLimit,
      aiChatAssistantLimit,
      aiTemplateLimit,
      editAudioLimit,
      videoToTextLimit,
      aiVisionLimit,
      webScriptingLimit,
      youTubeAnalyserLimit,
      aiRewriterLimit,
      speechToTextLimit,
      aiVoiceoverLimit,
      aiCodeGenerateLimit,
      selectedVIP,
      selectedPremium,
    });
    res.status(200).json({ status: "success", data: package });
  } catch (error) {
    res
      .status(500)
      .json({ status: "failed", message: "An error occurred", error: error });
    console.log(error);
  }
};
const updatePackage = async (req, res) => {
  const {
    id,
    title,
    packageType,
    packageDuration,
    price,
    textToImage,
    imagination,
    packageCurrency,
    imageCaption,
    freeLimit,
    chatImageLimit,
    imageAudioLimit,
    scratchToCodeLimit,
    grammarCheckingLimit,
    textToParaphraserLimit,
    aiChatAssistantLimit,
    aiTemplateLimit,
    editAudioLimit,
    videoToTextLimit,
    aiVisionLimit,
    webScriptingLimit,
    youTubeAnalyserLimit,
    aiRewriterLimit,
    speechToTextLimit,
    aiVoiceoverLimit,
    aiCodeGenerateLimit,
    selectedVIP,
    selectedPremium,
  } = req.body;

  const updatePackage = {
    title,
    packageType,
    packageDuration,
    price,
    textToImage,
    imagination,
    packageCurrency,
    imageCaption,
    freeLimit,
    chatImageLimit,
    imageAudioLimit,
    scratchToCodeLimit,
    grammarCheckingLimit,
    textToParaphraserLimit,
    aiChatAssistantLimit,
    aiTemplateLimit,
    editAudioLimit,
    videoToTextLimit,
    aiVisionLimit,
    webScriptingLimit,
    youTubeAnalyserLimit,
    aiRewriterLimit,
    speechToTextLimit,
    aiVoiceoverLimit,
    aiCodeGenerateLimit,
    selectedVIP,
    selectedPremium,
  };

  try {
    const data = await packageModel.findByIdAndUpdate(id, updatePackage, {
      new: true,
    });
    res.status(200).json({ status: "success", data: data });
  } catch (error) {
    res
      .status(500)
      .json({ status: "failed", message: "An error occurred", error: error });
    console.log(error);
  }
};

const createPackageList = async (req, res) => {
  try {
    const data = await packageModel.find({ active: "true" });
    const MonthlyData = data.filter(
      (item) => item.packageDuration === "Monthly"
    );
    const YarelyData = data.filter((item) => item.packageDuration === "Yearly");
    const lifeTimeData = data.filter(
      (item) => item.packageDuration === "Life-Time"
    );
    const totalPackage = data.length;
    res.status(200).json({
      status: "success",
      data,
      MonthlyData,
      YarelyData,
      lifeTimeData,
      totalPackage,
    });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
  }
};

const createPackageListAdmin = async (req, res) => {
  try {
    const data = await packageModel.find();

    const monthlyData = data.filter(
      (item) => item.packageDuration === "Monthly"
    );
    const yarelyData = data.filter((item) => item.packageDuration === "Yearly");
    const lifeTimeData = data.filter(
      (item) => item.packageDuration === "Life-Time"
    );
    const totalPackage = data.length;
    res.status(200).json({
      status: "success",
      data,
      monthlyData,
      yarelyData,
      lifeTimeData,
      totalPackage,
    });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
  }
};

const packageDelete = async (req, res) => {
  const id = req.params.id;
  const Query = { _id: id };
  try {
    const data = await packageModel.deleteOne(Query);
    res
      .status(200)
      .json({ status: "success", message: "Delete successfully", data: data });
  } catch (error) {
    res
      .status(400)
      .json({ status: "error", message: "Not delete data", error: error });
  }
};

const orderPackage = async (req, res) => {
  const id = req.params.selectedPlanId;
  const Query = { _id: id };
  try {
    const data = await packageModel.findOne(Query);
    res.status(200).json({ status: "success", data: data });
  } catch (error) {
    res
      .status(400)
      .json({ status: "error", message: "Not delete data", error: error });
  }
};

const showHidePackage = async (req, res) => {
  const { id, bullionData } = req.body;
  try {
    const matchId = { _id: id };
    const updateData = await packageModel.updateOne(matchId, {
      $set: { active: bullionData },
    });
    if (updateData.nModified === 0) {
      return res.status(404).json({
        status: "failed",
        message: "User not found or no changes applied",
      });
    }

    res.status(200).json({ message: "Update successful" });
  } catch (error) {
    console.error("Error updating data:", error);
    res.status(500).json({
      status: "error",
      message: "An error occurred during data update",
    });
  }
};

const editPackageDataGet = async (req, res) => {
  const { id } = req.body;
  try {
    const data = await packageModel.findById(id);

    if (!data) {
      return res
        .status(404)
        .json({ status: "error", message: "Data not found" });
    }
    res.status(200).json({
      status: "success",
      message: "Data found successfully",
      data: data,
    });
  } catch (error) {
    res
      .status(400)
      .json({ status: "error", message: "Failed to fetch data", error: error });
  }
};

module.exports = {
  createPackage,
  createPackageList,
  packageDelete,
  orderPackage,
  showHidePackage,
  createPackageListAdmin,
  editPackageDataGet,
  updatePackage,
};
