const OpenAI = require("openai");
const fs = require("fs");
const userModel = require("../DataModel/AuthDataModel");
const packageModel = require("../DataModel/packageModel");
const path = require("path");
const openAiApiModel = require("../DataModel/OpenAISettingModel");
async function getOpenAIKey() {
  try {
    const settings = await openAiApiModel.findOne();
    return settings ? settings.openAiAPI : null;
  } catch (error) {
    console.error("Error fetching OpenAI API key:", error);
    return null;
  }
}

const videoToTextController = async (req, res) => {
  const apiKey = await getOpenAIKey();
  const openai = new OpenAI({
    apiKey: apiKey,
  });

  const email = req.headers.email;
  try {
    const user = await userModel.findOne({ email });
    if (!user) {
      return res.status(400).json({ error: "User not found" });
    }
    const userPackage = await packageModel.aggregate([
      {
        $match: {
          packageType: user.plan,
          packageDuration: user.packageTime,
        },
      },
    ]);
    if (!userPackage || userPackage.length === 0) {
      return res
        .status(500)
        .json({ error: "User package information not found" });
    }
    const selectedPackage = userPackage[0];
    if (user.apiUseVideoToTextLimit >= selectedPackage.videoToTextLimit) {
      const AUDIO_FOLDER = "./AllFile/VideoToText";
      fs.readdir(AUDIO_FOLDER, (err, files) => {
        if (err) {
          console.error(err);
          return res
            .status(500)
            .json({ success: false, error: "Error reading audio files" });
        }
        files.forEach((file) => {
          const filePath = path.join(AUDIO_FOLDER, file);
          fs.unlinkSync(filePath);
        });
      });

      return res
        .status(402)
        .json({ error: "Access limit exceeded for audio generation" });
    }

    const AUDIO_FOLDER = "./AllFile/VideoToText";
    fs.readdir(AUDIO_FOLDER, async (err, files) => {
      if (err) {
        console.error(err);
        return res
          .status(500)
          .json({ success: false, error: "Error reading audio files" });
      }

      if (files.length > 0) {
        const audioFile = `${AUDIO_FOLDER}/${files[0]}`;
        try {
          const transcription = await openai.audio.transcriptions.create({
            file: fs.createReadStream(audioFile),
            model: "whisper-1",
          });
          const text = transcription.text;

          await userModel.findOneAndUpdate(
            { email },
            { $inc: { apiUseVideoToTextLimit: 1 } }
          );

          // Delete the audio file
          files.forEach((file) => {
            const filePath = path.join(AUDIO_FOLDER, file);
            fs.unlinkSync(filePath);
          });

          res.status(200).json({ success: true, text: text });
        } catch (error) {
          res
            .status(500)
            .json({ success: false, error: "Text could not be generated" });
        }
      } else {
        res.status(500).json({ success: false, error: "No audio files found" });
      }
    });
  } catch (error) {
    console.error("Error processing request:", error);
    res
      .status(500)
      .json({ success: false, error: "Text could not be generated" });
  }
};

module.exports = { videoToTextController };
