const mongoose = require("mongoose");
const BlingInfoSchema = mongoose.Schema(
  {
    orderId: { type: String },
    packageId: { type: String },
    packageType: { type: String },
    packagePrice: { type: Number },
    packageTime: { type: String },
    name: { type: String },
    phone: { type: Number },
    emailVal: { type: String },
    addressVal: { type: String },
    countryVal: { type: String },
    cityVal: { type: String },
    stateVal: { type: String },
    orderStatus: { type: String, default: "New" },
    zipVal: { type: Number },
    selectedVIPAssistant: [
      {
        value: { type: String },
        assistantIcon: { type: String },
        assistantName: { type: String },
        assistantCategory: { type: String },
      },
    ],
    selectedTagPremiumAssistant: [
      {
        value: { type: String },
        assistantIcon: { type: String },
        assistantName: { type: String },
        assistantCategory: { type: String },
      },
    ],
    createDate: { type: Date, default: Date.now() },
  },
  { versionKey: false }
);

const BlingDataModel = mongoose.model("BlingInfo", BlingInfoSchema);
module.exports = BlingDataModel;
