const multer = require("multer");
const path = require("path");
const fs = require("fs");

const AUDIO_FOLDER = path.join(__dirname, "../AllFile/AudioFiles");

try {
  fs.accessSync(AUDIO_FOLDER, fs.constants.R_OK | fs.constants.W_OK);
} catch (err) {
  console.error(`Error accessing ${AUDIO_FOLDER}: ${err}`);
  process.exit(1); 
}

let fileCounter = 0; 

const destination = (req, file, cb) => {
  cb(null, AUDIO_FOLDER);
};

const filename = (req, file, cb) => {
  fileCounter++;
  const fileExt = path.extname(file.originalname);
  const fileName = `${fileCounter}${fileExt}`;
  cb(null, fileName);
};

const storage = multer.diskStorage({
  destination: destination,
  filename: filename,
});


const uploadAudio = multer({
  storage: storage,
  limits: {
    fileSize: 20 * 1024 * 1024, 
  },
  fileFilter: (req, file, cb) => {

    if (
      file.mimetype === "audio/mpeg" ||
      file.mimetype === "audio/mpga" ||
      file.mimetype === "audio/m4a" ||
      file.mimetype === "audio/webm" ||
      file.mimetype === "audio/mp4" ||
      file.mimetype === "audio/mp3" ||
      file.mimetype === "audio/wav"
    ) {
      cb(null, true); 
    } else {
      cb(new Error("Only upload supported audio files.")); 
    }
  },
});

module.exports = uploadAudio;




// const multer = require("multer");
// const path = require("path");
// const fs = require("fs");
// const AUDIO_FOLDER = "../AllFile/AudioFiles";
// const existingFiles = fs.readdirSync(AUDIO_FOLDER);
// let fileCounter = existingFiles.length;
// const destination = (req, file, cb) => {
//   cb(null, AUDIO_FOLDER);
// };

// const filename = (req, file, cb) => {
//   fileCounter++;
//   const fileExt = path.extname(file.originalname);
//   const fileName = `${fileCounter}${fileExt}`;
//   cb(null, fileName);
// };

// const storage = multer.diskStorage({
//   destination: destination,
//   filename: filename, 
// });

// const AudioFileUp = multer({
//   storage: storage,
//   limits: {
//     fileSize: 20 * 1024 * 1024,
//   },
//   fileFilter: (req, file, cb) => {
//     if (
//       file.mimetype === "audio/mpeg" ||
//       file.mimetype === "audio/mpga" ||
//       file.mimetype === "audio/m4a" ||
//       file.mimetype === "audio/webm" ||
//       file.mimetype === "audio/mp4" ||
//       file.mimetype === "audio/mp3" ||
//       file.mimetype === "audio/wav"
//     ) {
//       cb(null, true);
//     } else {
//       cb(new Error("Only upload supported audio files."));
//     }
//   },
// });

// module.exports = AudioFileUp;


