const multer = require("multer");
const path = require("path");
const fs = require("fs");

const AUDIO_FOLDER = "./AllFile/EditAudioFile";
const existingFiles = fs.readdirSync(AUDIO_FOLDER);
let fileCounter = existingFiles.length;

// Create a function to handle destination
const destination = (req, file, cb) => {
  cb(null, AUDIO_FOLDER);
};

// Create a function to handle filename
const filename = (req, file, cb) => {
  fileCounter++;
  const fileExt = path.extname(file.originalname);
  const fileName = `${fileCounter}${fileExt}`;
  cb(null, fileName);
};

const storage = multer.diskStorage({
  destination: destination,
  filename: filename,
});

const EditAudioUP = multer({
  storage: storage,
  limits: {
    fileSize: 20 * 1024 * 1024,
  },
  fileFilter: (req, file, cb) => {
    if (
      file.mimetype === "audio/mpeg" ||
      file.mimetype === "audio/mpga" ||
      file.mimetype === "audio/m4a" ||
      file.mimetype === "audio/webm" ||
      file.mimetype === "audio/mp4" ||
      file.mimetype === "audio/mp3" ||
      file.mimetype === "audio/wav"
    ) {
      cb(null, true);
    } else {
      cb(new Error("Only upload supported audio files."));
    }
  },
});

module.exports = EditAudioUP;
