const axios = require("axios");
module.exports = async (req, res, next) => {
  try {
    const token = req.body.token;
    const response = await axios.get(
      `https://www.googleapis.com/oauth2/v3/userinfo?access_token=${token}`
    );
    const { email, name, given_name, picture } = response.data;
    req.userInfo = { email, name, userName: given_name, image: picture };
    next();
  } catch (error) {
    console.error("Error fetching user information from Google:", error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};
