const multer = require("multer");
const path = require("path");
const UPLOAD_FOLDER = "./AllFile/Vision_image";
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, UPLOAD_FOLDER);
  },
  filename: (req, file, cb) => {
    const fileExt = path.extname(file.originalname);
    const fileName = Date.now();
    cb(null, fileName + fileExt);
  },
});

const visionImageUpload = multer({
  storage: storage,
  limits: {
    fileSize: 50000000, //100mb
  },

  fileFilter: (req, file, cb) => {
    if (
      file.mimetype === "image/jpeg" ||
      file.mimetype === "image/jpg" ||
      file.mimetype === "image/png"
    ) {
      cb(null, true);
    } else {
      cb(new Error("Only upload JPEG, JPG, PNG files."));
    }
  },
});

module.exports = visionImageUpload;
