const nodemailer = require("nodemailer");
const SMTPModel = require("../DataModel/SMTPModel");
const sendEmail = async (emailTo, emailText, emailSubject) => {
  try {
    const smtpData = await SMTPModel.findOne();
    let transporter = nodemailer.createTransport({
      host: smtpData.smtpHost,
      port: smtpData.smtpPort,
      secure: true,
      auth: {
        user: smtpData.smtpSenderEmail,
        pass: smtpData.smtpPassword,
      },
    });
    let mailOptions = {
      from: `${smtpData.smtpSenderName} <${smtpData.smtpSenderEmail}>`,
      to: emailTo,
      subject: emailSubject,
      text: emailText,
    };
    const info = await transporter.sendMail(mailOptions);
    console.log("Email sent:", info.messageId);

    return info;
  } catch (error) {
    console.error("Error sending email:", error);
    throw error;
  }
};

module.exports = sendEmail;
