const userModel = require("../DataModel/AuthDataModel");
const packModel = require("../DataModel/packageModel");
const ModelAffiliate = require("../DataModel/AffiliateModel");
const jwt = require("jsonwebtoken");
const bcrypt = require("bcryptjs");
const otpModel = require("../DataModel/OtpModel");
const sendEmail = require("../Utility/EmailDomain");

// login with google
const googleLogin = async (req, res) => {
  const { email, userName, name, image, refId } = req.userInfo;
  try {
    let user = await userModel.findOne({ email });
    if (!user) {
      user = new userModel({ email, name, userName, image, refId });
      await user.save();
    }
    const payload = {
      exp: Math.floor(Date.now() / 1000) + 24 * 60 * 60,
      data: user.email,
    };
    const token = jwt.sign(payload, "dfhdiuru238437@#");
    res.status(200).json({ status: "success", token: token, data: user });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
  }
};

const authRegistration = async (req, res) => {
  const { name, userName, email, auth, password, refId } = req.body;
  try {
    const existingUser = await userModel.findOne({ email });
    if (existingUser) {
      return res
        .status(400)
        .json({ status: "failed", message: "Email address already exists" });
    }
    const hashedPassword = await bcrypt.hash(password, 5);
    const newUser = await userModel.create({
      name,
      userName,
      email,
      auth,
      refId,
      password: hashedPassword,
    });

    res.status(200).json({ status: "success", data: newUser });
  } catch (error) {
    console.error("Error registering user:", error);
    res.status(500).json({ status: "error", message: "Internal server error" });
  }
};

const authLogin = async (req, res) => {
  const { email, password } = req.body;
  try {
    const user = await userModel.findOne({ email });
    if (!user) {
      return res.status(401).json({ msg: "Unauthorized" });
    }
    const passwordMatch = await bcrypt.compare(password, user.password);
    if (!passwordMatch) {
      return res.status(401).json({ msg: "Unauthorized" });
    }
    const payload = {
      exp: Math.floor(Date.now() / 1000) + 24 * 60 * 60,
      data: user.email,
    };
    const token = jwt.sign(payload, "dfhdiuru238437@#");
    res.status(200).json({ status: "success", token: token, data: user });
  } catch (error) {
    res.status(402).json({ msg: "failed", error: error });
  }
};
const authUpdate = async (req, res) => {
  try {
    const User_mail = req.headers["email"];
    const matchEmail = { email: User_mail };
    const { name, userName, email, image, password } = req.body;
    const hashedPassword = await bcrypt.hash(password, 5);
    const updateData = await userModel.updateOne(matchEmail, {
      $set: { name, userName, email, image, password: hashedPassword },
    });
    if (updateData.nModified === 0) {
      return res.status(404).json({
        status: "failed",
        message: "User not found or no changes applied",
      });
    }
    res.status(200).json({ message: "Update successful", data: updateData });
  } catch (error) {
    console.error("Error updating data:", error);
    res.status(500).json({
      status: "error",
      message: "An error occurred during data update",
    });
  }
};
const totalPaidUserList = async (req, res) => {
  try {
    const pageNo = Number(req.params.pageNo);
    const perPage = Number(req.params.perPage);
    const searchValue = req.params.searchKeyword;
    const skipRow = (pageNo - 1) * perPage;
    const searchRgx = new RegExp(searchValue, "i");
    const searchQuery =
      searchValue !== "0"
        ? {
            $or: [
              { name: searchRgx },
              { email: searchRgx },
              { plan: searchRgx },
              { packageTime: searchRgx },
            ],
          }
        : {};

    const matchCondition = {
      $and: [searchQuery, { auth: "user" }, { plan: { $ne: "Free" } }],
    };
    const aggregatePipeline = [
      {
        $match: matchCondition,
      },
      {
        $sort: { Date: -1 },
      },
      {
        $facet: {
          Total: [{ $count: "count" }],
          Row: [{ $skip: skipRow }, { $limit: perPage }],
        },
      },
    ];

    const [aggResult] = await userModel.aggregate(aggregatePipeline);
    const totalCount =
      aggResult.Total.length > 0 ? aggResult.Total[0].count : 0;
    const users = aggResult.Row;
    res.status(200).json({
      status: "success",
      data: { users, totalCount },
    });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
  }
};

const getAllUserList = async (req, res) => {
  try {
    const pageNo = Number(req.params.pageNo);
    const perPage = Number(req.params.perPage);
    const searchValue = req.params.searchKeyword;
    const skipRow = (pageNo - 1) * perPage;
    const searchRgx = new RegExp(searchValue, "i");
    const searchQuery =
      searchValue !== "0"
        ? {
            $or: [
              { name: searchRgx },
              { email: searchRgx },
              { plan: searchRgx },
              { packageTime: searchRgx },
            ],
          }
        : {};
    const aggregatePipeline = [
      {
        $match: {
          $and: [searchQuery, { auth: "user" }, { plan: "Free" }],
        },
      },
      {
        $sort: { Date: -1 },
      },
      {
        $facet: {
          Total: [{ $count: "count" }],
          Row: [{ $skip: skipRow }, { $limit: perPage }],
        },
      },
    ];
    const [aggResult] = await userModel.aggregate(aggregatePipeline);
    const totalCount =
      aggResult.Total.length > 0 ? aggResult.Total[0].count : 0;
    const users = aggResult.Row;
    res.status(200).json({
      status: "success",
      data: { users, totalCount },
    });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
  }
};

const getUserDetails = async (req, res) => {
  try {
    const email = req.headers["email"];
    const data = await userModel.aggregate([
      { $match: { email: email } },
      {
        $project: {
          _id: 1,
          name: 1,
          userName: 1,
          email: 1,
          image: 1,
          auth: 1,
          plan: 1,
          packageTime: 1,
          password: 1,
          Date: 1,
          apiUseTextToImage: 1,
          apiUseImagination: 1,
          apiUseImageCaption: 1,
          apiUseFreeLimit: 1,
          apiUseChatImageLimit: 1,
          apiUseImageAudioLimit: 1,
          apiUseScratchToCodeLimit: 1,
          apiUseGrammarChekiangLimit: 1,
          apiUseTextToParaphraserLimit: 1,
          apiUseAiChatAssistantLimit: 1,
          apiUseAiTemplateLimit: 1,
          apiUseEditAudioLimit: 1,
          apiUseVideoToTextLimit: 1,
          apiUseAiVisionLimit: 1,
          apiUseWebScriptingLimit: 1,
          apiUseYouTubeAnalyserLimit: 1,
          apiUseAiRewriterLimit: 1,
          apiUseSpeechToTextLimit: 1,
          apiUseAiVoiceoverLimit: 1,
          apiUseAiCodeGenerateLimit: 1,
          apiUseTextParaphraser: 1,
          selectedVIPAssistant: 1,
          selectedPremiumAssistant: 1,
        },
      },
    ]);

    if (data.length === 0) {
      return res
        .status(404)
        .json({ status: "failed", message: "User not found" });
    }

    res.status(200).json({ status: "success", data: data });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
  }
};

const paidUserCountAdmin = async (req, res) => {
  try {
    const currentDate = new Date();
    const firstDayOfLastMonth = new Date(
      currentDate.getFullYear(),
      currentDate.getMonth() - 1,
      1
    );
    const pipeline = [
      {
        $match: {
          auth: "user",
          plan: { $ne: "Free" },
        },
      },
      {
        $group: {
          _id: {
            year: { $year: "$Date" },
            month: { $month: "$Date" },
            day: { $dayOfMonth: "$Date" },
          },
          count: { $sum: 1 },
          totalPrice: { $sum: "$price" },
        },
      },
    ];

    const yearlyMonthlyDailyUserCounts = await userModel.aggregate(pipeline);
    const currentMonth = currentDate.getMonth() + 1;
    const currentYear = currentDate.getFullYear();

    const currentMonthStats = yearlyMonthlyDailyUserCounts
      .filter(
        (item) =>
          item._id.year === currentYear && item._id.month === currentMonth
      )
      .reduce(
        (acc, val) => {
          acc.count += val.count;
          acc.totalPrice += val.totalPrice;
          return acc;
        },
        { count: 0, totalPrice: 0 }
      );

    const lastMonthStats = yearlyMonthlyDailyUserCounts
      .filter((item) => {
        const date = new Date(item._id.year, item._id.month - 1, item._id.day);
        return (
          date >= firstDayOfLastMonth &&
          date < new Date(currentYear, currentMonth - 1, 1)
        );
      })
      .reduce(
        (acc, val) => {
          acc.count += val.count;
          acc.totalPrice += val.totalPrice;
          return acc;
        },
        { count: 0, totalPrice: 0 }
      );

    const todayStats = yearlyMonthlyDailyUserCounts
      .filter((item) => {
        const date = new Date(item._id.year, item._id.month - 1, item._id.day);
        return (
          date.getFullYear() === currentDate.getFullYear() &&
          date.getMonth() === currentDate.getMonth() &&
          date.getDate() === currentDate.getDate()
        );
      })
      .reduce(
        (acc, val) => {
          acc.count += val.count;
          acc.totalPrice += val.totalPrice;
          return acc;
        },
        { count: 0, totalPrice: 0 }
      );

    const yearlyStats = yearlyMonthlyDailyUserCounts
      .filter((item) => item._id.year === currentYear)
      .reduce(
        (acc, val) => {
          acc.count += val.count;
          acc.totalPrice += val.totalPrice;
          return acc;
        },
        { count: 0, totalPrice: 0 }
      );

    const totalStats = yearlyMonthlyDailyUserCounts.reduce(
      (acc, val) => {
        acc.count += val.count;
        acc.totalPrice += val.totalPrice;
        return acc;
      },
      { count: 0, totalPrice: 0 }
    );

    res.status(200).json({
      status: "success",
      currentMonthCount: currentMonthStats.count,
      currentMonthTotalPrice: currentMonthStats.totalPrice,
      lastMonthCount: lastMonthStats.count,
      lastMonthTotalPrice: lastMonthStats.totalPrice,
      todayCount: todayStats.count,
      todayTotalPrice: todayStats.totalPrice,
      yearlyCount: yearlyStats.count,
      yearlyTotalPrice: yearlyStats.totalPrice,
      totalCount: totalStats.count,
      totalTotalPrice: totalStats.totalPrice,
    });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
    console.log(error);
  }
};

const freeUserCountAdmin = async (req, res) => {
  try {
    const currentDate = new Date();

    const firstDayOfLastMonth = new Date(
      currentDate.getFullYear(),
      currentDate.getMonth() - 1,
      1
    );

    const pipeline = [
      {
        $match: {
          auth: "user",
          plan: "Free",
        },
      },
      {
        $group: {
          _id: {
            year: { $year: "$Date" },
            month: { $month: "$Date" },
            day: { $dayOfMonth: "$Date" },
          },
          count: { $sum: 1 },
        },
      },
    ];

    const yearlyMonthlyDailyUserCounts = await userModel.aggregate(pipeline);

    const currentMonth = currentDate.getMonth() + 1;
    const currentYear = currentDate.getFullYear();

    const currentMonthCount = yearlyMonthlyDailyUserCounts
      .filter(
        (item) =>
          item._id.year === currentYear && item._id.month === currentMonth
      )
      .reduce((acc, val) => acc + val.count, 0);

    const lastMonthCount = yearlyMonthlyDailyUserCounts
      .filter((item) => {
        const date = new Date(item._id.year, item._id.month - 1, item._id.day);
        return (
          date >= firstDayOfLastMonth &&
          date < new Date(currentYear, currentMonth - 1, 1)
        );
      })
      .reduce((acc, val) => acc + val.count, 0);

    const todayCount = yearlyMonthlyDailyUserCounts
      .filter((item) => {
        const date = new Date(item._id.year, item._id.month - 1, item._id.day);
        return (
          date.getFullYear() === currentDate.getFullYear() &&
          date.getMonth() === currentDate.getMonth() &&
          date.getDate() === currentDate.getDate()
        );
      })
      .reduce((acc, val) => acc + val.count, 0);

    const yearlyCount = yearlyMonthlyDailyUserCounts
      .filter((item) => item._id.year === currentYear)
      .reduce((acc, val) => acc + val.count, 0);

    const totalCount = yearlyMonthlyDailyUserCounts.reduce(
      (acc, val) => acc + val.count,
      0
    );

    res.status(200).json({
      status: "success",
      currentMonthCount,
      lastMonthCount,
      todayCount,
      yearlyCount,
      totalCount,
    });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
    console.log(error);
  }
};

const totalLimit = async (req, res) => {
  const token = req.headers.token;
  try {
    jwt.verify(token, "dfhdiuru238437@#", async (error, decoded) => {
      if (error) {
        return res
          .status(401)
          .json({ status: "unauthorized", error: "Invalid token" });
      }
      const email = decoded.data;
      const user = await userModel.findOne({ email: email });

      if (!user) {
        return res
          .status(404)
          .json({ status: "failed", message: "User not found" });
      }

      const userPackage = user.plan;
      const userPackageTime = user.packageTime;
      if (!userPackage || !userPackageTime) {
        return res.status(400).json({
          status: "failed",
          message: "User package information missing",
        });
      }

      const packageMatch = await packModel.findOne({
        packageType: userPackage,
        packageDuration: userPackageTime,
      });

      if (!packageMatch) {
        return res
          .status(400)
          .json({ status: "failed", message: "Package information not found" });
      }
      res.status(200).json({ status: "success", data: packageMatch });
    });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
  }
};

const verifyEmail = async (req, res) => {
  const email = req.body.email;
  const OTPCode = Math.floor(100000 + Math.random() * 900000);
  try {
    const UserCount = await userModel.aggregate([
      { $match: { email: email } },
      { $count: "total" },
    ]);

    if (UserCount.length > 0) {
      await otpModel.create({ email: email, OTP: OTPCode });
      await sendEmail(
        email,
        `Your OTP code is: ${OTPCode}`,
        "OTP verification Code"
      );

      res.status(200).json({ status: "success", data: email });
    } else {
      res.status(404).json({ status: "error", message: "User not found" });
    }
  } catch (error) {
    console.log(error);
    res
      .status(500)
      .json({ status: "error", message: "Failed to send OTP code" });
  }
};
const recoverVerifyOTP = async (req, res) => {
  const email = req.params.email;
  const OTPCode = req.params.OTP;
  const status = 0;
  const statusUpdate = 1;
  try {
    const OtpCount = await otpModel.aggregate([
      { $match: { email: email, OTP: OTPCode, status: status } },
      { $count: "total" },
    ]);
    if (OtpCount.length > 0) {
      const OTPUpdate = await otpModel.updateOne(
        { email: email, OTP: OTPCode, status: status },
        { email: email, OTP: OTPCode, status: statusUpdate }
      );
      res.status(200).json({ status: "success", data: OTPUpdate });
    } else {
      res.status(400).json({ status: "failed", data: "Invalid OTP code" });
    }
  } catch (error) {
    res.status(400).json({ status: "failed", data: error });
  }
};
const recoverRestPassword = async (req, res) => {
  const email = req.body["email"];
  const OTPCode = req.body["OTP"];
  const NewPass = req.body["password"];
  const statusUpdate = 1;
  try {
    const OTPUsedCount = await otpModel.aggregate([
      { $match: { email: email, OTP: OTPCode, status: statusUpdate } },
      { $count: "total" },
    ]);
    if (OTPUsedCount.length > 0) {
      const hashedNewPass = await bcrypt.hash(NewPass, 10);
      const PassUpdate = await userModel.updateOne(
        { email: email },
        {
          password: hashedNewPass,
        }
      );
      res.status(200).json({ status: "success", data: PassUpdate });
    } else {
      res.status(400).json({ status: "fail", data: "Invalid Request" });
    }
  } catch (e) {
    res.status(400).json({ status: "fail", data: e });
  }
};

const affiliateSubscription = async (req, res) => {
  const id = req.params.id;
  try {
    const countResult = await userModel.aggregate([
      {
        $match: {
          refId: id,
          plan: { $ne: "free" },
        },
      },
      {
        $count: "total",
      },
    ]);
    if (countResult.length > 0 && countResult[0].total > 0) {
      const allUserData = await userModel.aggregate([
        {
          $match: {
            refId: id,
            plan: { $ne: "free" },
          },
        },
        {
          $project: {
            name: 1,
            userName: 1,
            Date: 1,
          },
        },
      ]);

      res.status(200).json({
        status: "success",
        count: countResult[0].total,
        data: allUserData,
      });
    } else {
      res.status(200).json({ status: "success", count: 0 });
    }
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
  }
};
const totalPrice = async (req, res) => {
  const id = req.params.id;

  try {
    const users = await userModel.find({ refId: id });
    if (users.length === 0) {
      return res
        .status(404)
        .json({ status: "failed", message: "Users not found" });
    }
    let totalPrice = 0;
    for (const user of users) {
      const userPackage = user.plan;
      const userPackageTime = user.packageTime;
      if (!userPackage || !userPackageTime) {
        return res.status(400).json({
          status: "failed",
          message: "User package information missing",
        });
      }

      const packageMatches = await packModel.find({
        packageType: userPackage,
        packageDuration: userPackageTime,
      });
      if (packageMatches.length === 0) {
        return res
          .status(400)
          .json({ status: "failed", message: "Package information not found" });
      }
      packageMatches.forEach((packageMatch) => {
        totalPrice += packageMatch.price;
      });
    }
    res.status(200).json({ status: "success", totalPrice: totalPrice });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
  }
};
const deleteAccount = async (req, res) => {
  const { currentPassword, id } = req.body;
  const email = req.headers["email"];
  try {
    const user = await userModel.findOne({ _id: id, email: email });
    if (!user) {
      return res.status(404).json({ message: "User not found" });
    }
    const isPasswordMatch = await bcrypt.compare(
      currentPassword,
      user.password
    );
    if (!isPasswordMatch) {
      return res.status(401).json({ message: "Password incorrect" });
    }
    const deleteResult = await userModel.deleteOne({
      _id: id,
      email: email,
    });
    if (deleteResult.deletedCount === 1) {
      res.status(200).json({ message: "Account deleted successfully" });
    } else {
      res.status(500).json({ message: "Failed to delete account" });
    }
  } catch (error) {
    res.status(500).json({ message: "Internal server error", error });
  }
};
const deleteUser = async (req, res) => {
  const id = req.params.id;
  const Query = { _id: id };
  try {
    const data = await userModel.deleteOne(Query);
    res
      .status(200)
      .json({ status: "success", message: "Delete successfully", data: data });
  } catch (error) {
    res
      .status(400)
      .json({ status: "error", message: "Not delete data", error: error });
  }
};

const allConsumeDataAdmin = async (req, res) => {
  try {
    // Get current date
    const currentDate = new Date();

    // Get first day of last month
    const firstDayOfLastMonth = new Date(
      currentDate.getFullYear(),
      currentDate.getMonth() - 1,
      1
    );

    const pipeline = [
      {
        $match: {
          auth: "user",
          plan: { $ne: "Free" },
        },
      },
      {
        $group: {
          _id: {
            year: { $year: "$Date" },
            month: { $month: "$Date" },
            day: { $dayOfMonth: "$Date" },
          },
          count: { $sum: 1 },
          apiUsageImage: { $sum: "$apiUsageImage" },
          apiUseCode: { $sum: "$apiUseCode" },
          apiUseTextToAudio: { $sum: "$apiUseTextToAudio" },
          apiUseArticle: { $sum: "$apiUseArticle" },
          apiUseChat: { $sum: "$apiUseChat" },
          apiUseAudioToText: { $sum: "$apiUseAudioToText" },
        },
      },
    ];

    const yearlyMonthlyDailyUserCounts = await userModel.aggregate(pipeline);

    const currentMonth = currentDate.getMonth() + 1;
    const currentYear = currentDate.getFullYear();

    // Calculate current month count and total price
    const currentMonthStats = yearlyMonthlyDailyUserCounts
      .filter(
        (item) =>
          item._id.year === currentYear && item._id.month === currentMonth
      )
      .reduce(
        (acc, val) => {
          acc.apiUsageImage += val.apiUsageImage;
          acc.apiUseCode += val.apiUseCode;
          acc.apiUseTextToAudio += val.apiUseTextToAudio;
          acc.apiUseArticle += val.apiUseArticle;
          acc.apiUseChat += val.apiUseChat;
          acc.apiUseAudioToText += val.apiUseAudioToText;
          return acc;
        },
        {
          count: 0,
          apiUsageImage: 0,
          apiUseCode: 0,
          apiUseAudio: 0,
          apiUseArticle: 0,
          apiUseChat: 0,
          apiUseAudioToText: 0,
        }
      );

    // Calculate last month count and total price
    const lastMonthStats = yearlyMonthlyDailyUserCounts
      .filter((item) => {
        const date = new Date(item._id.year, item._id.month - 1, item._id.day);
        return (
          date >= firstDayOfLastMonth &&
          date < new Date(currentYear, currentMonth - 1, 1)
        );
      })
      .reduce(
        (acc, val) => {
          acc.apiUsageImage += val.apiUsageImage;
          acc.apiUseCode += val.apiUseCode;
          acc.apiUseTextToAudio += val.apiUseTextToAudio;
          acc.apiUseArticle += val.apiUseArticle;
          acc.apiUseChat += val.apiUseChat;
          acc.apiUseAudioToText += val.apiUseAudioToText;
          return acc;
        },
        {
          count: 0,
          apiUsageImage: 0,
          apiUseCode: 0,
          apiUseTextToAudio: 0,
          apiUseArticle: 0,
          apiUseChat: 0,
          apiUseAudioToText: 0,
        }
      );

    // Calculate yearly count and total price
    const yearlyStats = yearlyMonthlyDailyUserCounts
      .filter((item) => item._id.year === currentYear)
      .reduce(
        (acc, val) => {
          acc.apiUsageImage += val.apiUsageImage;
          acc.apiUseCode += val.apiUseCode;
          acc.apiUseTextToAudio += val.apiUseTextToAudio;
          acc.apiUseArticle += val.apiUseArticle;
          acc.apiUseChat += val.apiUseChat;
          acc.apiUseAudioToText += val.apiUseAudioToText;
          return acc;
        },
        {
          count: 0,
          apiUsageImage: 0,
          apiUseCode: 0,
          apiUseTextToAudio: 0,
          apiUseArticle: 0,
          apiUseChat: 0,
          apiUseAudioToText: 0,
        }
      );

    // Calculate total count and total price
    const totalStats = yearlyMonthlyDailyUserCounts.reduce(
      (acc, val) => {
        acc.apiUsageImage += val.apiUsageImage;
        acc.apiUseCode += val.apiUseCode;
        acc.apiUseTextToAudio += val.apiUseTextToAudio;
        acc.apiUseArticle += val.apiUseArticle;
        acc.apiUseChat += val.apiUseChat;
        acc.apiUseAudioToText += val.apiUseAudioToText;
        return acc;
      },
      {
        count: 0,
        apiUsageImage: 0,
        apiUseCode: 0,
        apiUseTextToAudio: 0,
        apiUseArticle: 0,
        apiUseChat: 0,
        apiUseAudioToText: 0,
      }
    );

    res.status(200).json({
      status: "success",

      currentMonthApiUsageImage: currentMonthStats.apiUsageImage,
      currentMonthApiUseCode: currentMonthStats.apiUseCode,
      currentMonthApiUseAudio: currentMonthStats.apiUseTextToAudio,
      currentMonthApiUseArticle: currentMonthStats.apiUseArticle,
      currentMonthApiUseChat: currentMonthStats.apiUseChat,
      currentMonthApiUseAudioToText: currentMonthStats.apiUseAudioToText,

      lastMonthApiUsageImage: lastMonthStats.apiUsageImage,
      lastMonthApiUseCode: lastMonthStats.apiUseCode,
      lastMonthApiUseAudio: lastMonthStats.apiUseTextToAudio,
      lastMonthApiUseArticle: lastMonthStats.apiUseArticle,
      lastMonthApiUseChat: lastMonthStats.apiUseChat,
      lastMonthApiUseAudioToText: lastMonthStats.apiUseAudioToText,

      yearlyApiUsageImage: yearlyStats.apiUsageImage,
      yearlyApiUseCode: yearlyStats.apiUseCode,
      yearlyApiUseAudio: yearlyStats.apiUseTextToAudio,
      yearlyApiUseArticle: yearlyStats.apiUseArticle,
      yearlyApiUseChat: yearlyStats.apiUseChat,
      yearlyApiUseAudioToText: yearlyStats.apiUseAudioToText,

      totalApiUsageImage: totalStats.apiUsageImage,
      totalApiUseCode: totalStats.apiUseCode,
      totalApiUseAudio: totalStats.apiUseTextToAudio,
      totalApiUseArticle: totalStats.apiUseArticle,
      totalApiUseChat: totalStats.apiUseChat,
      totalApiUseAudioToText: totalStats.apiUseAudioToText,
    });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
    console.log(error);
  }
};

const spendMonyCountForMarketingAdmin = async (req, res) => {
  try {
    const affiliateRecord = await ModelAffiliate.findOne({});

    if (!affiliateRecord) {
      throw new Error("Affiliate record not found");
    }

    // Get current date
    const currentDate = new Date();
    const firstDayOfLastMonth = new Date(
      currentDate.getFullYear(),
      currentDate.getMonth() - 1,
      1
    );
    const pipeline = [
      {
        $match: {
          auth: "user",
          refId: { $ne: "null" },
        },
      },
      {
        $group: {
          _id: {
            year: { $year: "$Date" },
            month: { $month: "$Date" },
            day: { $dayOfMonth: "$Date" },
          },
          totalPrice: { $sum: "$price" },
        },
      },
    ];

    const yearlyMonthlyDailyUserCounts = await userModel.aggregate(pipeline);

    const currentMonth = currentDate.getMonth() + 1;
    const currentYear = currentDate.getFullYear();

    // Calculate current month total price
    const currentMonthTotalPrice = yearlyMonthlyDailyUserCounts
      .filter(
        (item) =>
          item._id.year === currentYear && item._id.month === currentMonth
      )
      .reduce((acc, val) => acc + val.totalPrice, 0);

    // Calculate last month total price
    const lastMonthTotalPrice = yearlyMonthlyDailyUserCounts
      .filter((item) => {
        const date = new Date(item._id.year, item._id.month - 1, item._id.day);
        return (
          date >= firstDayOfLastMonth &&
          date < new Date(currentYear, currentMonth - 1, 1)
        );
      })
      .reduce((acc, val) => acc + val.totalPrice, 0);

    const yearlyTotalPrice = yearlyMonthlyDailyUserCounts
      .filter((item) => item._id.year === currentYear)
      .reduce((acc, val) => acc + val.totalPrice, 0);

    // Calculate total price
    const totalTotalPrice = yearlyMonthlyDailyUserCounts.reduce(
      (acc, val) => acc + val.totalPrice,
      0
    );

    // Calculate the percentage based on the retrieved value
    const percentage = affiliateRecord.Percentage;

    // Calculate percentage for each total price
    const currentMonthPercentage = (currentMonthTotalPrice * percentage) / 100;
    const lastMonthPercentage = (lastMonthTotalPrice * percentage) / 100;
    const yearlyPercentage = (yearlyTotalPrice * percentage) / 100;
    const totalPercentage = (totalTotalPrice * percentage) / 100;

    res.status(200).json({
      status: "success",
      currentMonthPercentage,
      lastMonthPercentage,
      yearlyPercentage,
      totalPercentage,
    });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
    console.log(error);
  }
};

module.exports = {
  authRegistration,
  authLogin,
  getUserDetails,
  getAllUserList,
  authUpdate,
  verifyEmail,
  recoverVerifyOTP,
  recoverRestPassword,
  affiliateSubscription,
  totalLimit,
  deleteAccount,
  totalPrice,
  deleteUser,
  googleLogin,
  freeUserCountAdmin,
  paidUserCountAdmin,
  totalPaidUserList,
  allConsumeDataAdmin,
  spendMonyCountForMarketingAdmin,
};
