const BlogDataModel = require("../DataModel/BlogPageModel");
const createBlog = async (req, res) => {
  try {
    const { title, description, tag, category, postCreate } = req.body;
    const thumbnail = req.files.thumbnail[0].path;
    const coverImage = req.files.coverImage[0].path;
    const blogData = {
      title,
      description,
      tag,
      category,
      postCreate,
      thumbnail,
      coverImage,
    };
    const data = await BlogDataModel.create(blogData);
    res.status(200).json({ message: "success", data: data });
  } catch (error) {
    console.error("Error creating blog post:", error);
    res.status(400).json({
      status: "error",
      message: "Failed to create data",
      error: error,
    });
  }
};
const updateBlogData = async (req, res) => {
  try {
    const { id, title, description, tag, category, postCreate } = req.body;
    let thumbnail, coverImage;
    if (req.files.thumbnail && req.files.thumbnail.length > 0) {
      thumbnail = req.files.thumbnail[0].path;
    }
    if (req.files.coverImage && req.files.coverImage.length > 0) {
      coverImage = req.files.coverImage[0].path;
    }

    // Construct the updated blog data
    const updatedBlogData = {
      title: title,
      description: description,
      tag: tag,
      category: category,
      postCreate: postCreate,

      ...(thumbnail && { thumbnail: thumbnail }),
      ...(coverImage && { coverImage: coverImage }),
    };

    const data = await BlogDataModel.findByIdAndUpdate(id, updatedBlogData, {
      new: true,
    });
    res.status(200).json({ message: "success", data: data });
  } catch (error) {
    console.error("Error updating blog post:", error);
    res.status(400).json({
      status: "error",
      message: "Failed to update data",
      error: error,
    });
  }
};

const readBlogDataAll = async (req, res) => {
  try {
    const data = await BlogDataModel.find({ active: true }).sort({
      createDate: -1,
    });
    res.status(200).json({ data: data });
  } catch (error) {
    console.error("Error creating blog post:", error);
    res.status(400).json({
      status: "error",
      message: "Failed to create data",
      error: error,
    });
  }
};

const blogList = async (req, res) => {
  try {
    const pageNo = Number(req.params.pageNo);
    const perPage = Number(req.params.perPage);
    const searchValue = req.params.searchKeyword;
    const skipRow = (pageNo - 1) * perPage;
    const searchRgx = new RegExp(searchValue, "i");
    const searchQuery =
      searchValue !== "0"
        ? {
            $or: [
              { orderId: searchRgx },
              { packageId: searchRgx },
              { name: searchRgx },
              { phone: searchRgx },
              { emailVal: searchRgx },
              { countryVal: searchRgx },
              { createDate: searchRgx },
              { packageTime: searchRgx },
              { packageType: searchRgx },
            ],
          }
        : {};

    const [totalCount, users] = await Promise.all([
      BlogDataModel.countDocuments(searchQuery),
      BlogDataModel.find(searchQuery).skip(skipRow).limit(perPage),
    ]);

    res.status(200).json({
      status: "success",
      data: { users, totalCount },
    });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
  }
};

const deleteBlog = async (req, res) => {
  const id = req.params.id;
  const Query = { _id: id };
  try {
    const data = await BlogDataModel.deleteOne(Query);
    res
      .status(200)
      .json({ status: "success", message: "Delete successfully", data: data });
  } catch (error) {
    res
      .status(400)
      .json({ status: "error", message: "Not delete data", error: error });
  }
};

const showHideBlog = async (req, res) => {
  const { id, bullionData } = req.body;
  try {
    const matchId = { _id: id };

    const updateData = await BlogDataModel.updateOne(matchId, {
      $set: { active: bullionData },
    });
    if (updateData.nModified === 0) {
      return res.status(404).json({
        status: "failed",
        message: "User not found or no changes applied",
      });
    }
    res.status(200).json({ message: "Update successful" });
  } catch (error) {
    console.error("Error updating data:", error);
    res.status(500).json({
      status: "error",
      message: "An error occurred during data update",
    });
  }
};
const editBlogData = async (req, res) => {
  const { id } = req.body;
  try {
    const data = await BlogDataModel.findById(id);

    if (!data) {
      return res
        .status(404)
        .json({ status: "error", message: "Data not found" });
    }
    res.status(200).json({
      status: "success",
      message: "Data found successfully",
      data: data,
    });
  } catch (error) {
    res
      .status(400)
      .json({ status: "error", message: "Failed to fetch data", error: error });
  }
};

module.exports = {
  createBlog,
  readBlogDataAll,
  blogList,
  deleteBlog,
  showHideBlog,
  editBlogData,
  updateBlogData,
};
