const faqModel = require("../DataModel/FAQModel");

const createFaqInfo = async (req, res) => {
  try {
    const { faqQuestion, faqAnswer } = req.body;
    const update = {
      faqQuestion,
      faqAnswer,
    };

    const updatedSmtpInfo = await faqModel.create(update);

    res.status(200).json({
      message: "faq create successfully",
      data: updatedSmtpInfo,
    });
  } catch (error) {
    console.error("Error creating or updating SMTP information:", error);
    res.status(400).json({
      status: "error",
      message: "Failed to create or update SMTP information",
      error: error.message,
    });
  }
};

// Controller function for retrieving SMTP information
const getFaqInfoAdmin = async (req, res) => {
  try {
    const result = await faqModel.find();

    if (result.length === 0) {
      return res.status(404).json({
        status: "error",
        message: "No FAQ information found",
      });
    }

    res.status(200).json({
      status: "success",
      message: "FAQ information retrieved successfully",
      data: result,
    });
  } catch (error) {
    console.error("Error retrieving FAQ information:", error);
    res.status(500).json({
      status: "error",
      message: "Failed to retrieve FAQ information",
      error: error.message,
    });
  }
};
const getFaqInfoUser = async (req, res) => {
  try {
    const result = await faqModel.find({ active: true });

    if (result.length === 0) {
      return res.status(404).json({
        status: "error",
        message: "No FAQ information found",
      });
    }

    res.status(200).json({
      status: "success",
      message: "FAQ information retrieved successfully",
      data: result,
    });
  } catch (error) {
    console.error("Error retrieving FAQ information:", error);
    res.status(500).json({
      status: "error",
      message: "Failed to retrieve FAQ information",
      error: error.message,
    });
  }
};
const showHideFaq = async (req, res) => {
  const { id, bullionData } = req.body;
  try {
    const matchId = { _id: id };

    const updateData = await faqModel.updateOne(matchId, {
      $set: { active: bullionData },
    });
    if (updateData.nModified === 0) {
      return res.status(404).json({
        status: "failed",
        message: "User not found or no changes applied",
      });
    }
    res.status(200).json({ message: "Update successful" });
  } catch (error) {
    console.error("Error updating data:", error);
    res.status(500).json({
      status: "error",
      message: "An error occurred during data update",
    });
  }
};
const deleteFaqData = async (req, res) => {
  const id = req.params.id;
  const Query = { _id: id };
  try {
    const data = await faqModel.deleteOne(Query);
    res
      .status(200)
      .json({ status: "success", message: "Delete successfully", data: data });
  } catch (error) {
    res
      .status(400)
      .json({ status: "error", message: "Not delete data", error: error });
  }
};

const updateFaqAdmin = async (req, res) => {
  const { updatedFaqQuestion, updatedFaqAnswer, id } = req.body;
  try {
    const updateData = {
      faqQuestion: updatedFaqQuestion,
      faqAnswer: updatedFaqAnswer,
    };
    const data = await faqModel.updateOne({ _id: id }, updateData);
    if (data.nModified > 0) {
      res.status(200).json({
        status: "success",
        message: "Update successful",
        data: data,
      });
    } else {
      res.status(404).json({
        status: "failed",
        message: "No matching document found to update",
        data: data,
      });
    }
  } catch (error) {
    res.status(500).json({
      status: "error",
      message: "Error updating social media data",
      error: error.message,
    });
  }
};

module.exports = {
  createFaqInfo,
  getFaqInfoAdmin,
  showHideFaq,
  getFaqInfoUser,
  deleteFaqData,
  updateFaqAdmin,
};
