const fs = require("fs");
const path = require("path");
// const request = require("request");
const base64 = require("base64-js");
const axios = require("axios");
const OpenAI = require("openai");
const imaginationModel = require("../DataModel/ImaginationImageModel");
const userModel = require("../DataModel/AuthDataModel");
const packageModel = require("../DataModel/packageModel");
const openAiApiModel = require("../DataModel/OpenAISettingModel");

// Function to asynchronously retrieve OpenAI API key
async function getOpenAIKey() {
  try {
    const settings = await openAiApiModel.findOne();
    return settings ? settings.openAiAPI : null;
  } catch (error) {
    console.error("Error fetching OpenAI API key:", error);
    return null;
  }
}
const ImaginationImage = async (req, res) => {
  debugger
  try {
    const apiKey = await getOpenAIKey();
    const openai = new OpenAI({
      apiKey: apiKey,
    });

    const { text } = req.body;
    const { email } = req.headers;

    const user = await userModel.findOne({ email });
    if (!user) {
      return res.status(400).json({ error: "User not found" });
    }

    const userPackage = await packageModel.aggregate([
      {
        $match: {
          packageType: user.plan,
          packageDuration: user.packageTime,
        },
      },
    ]);

    if (!userPackage || userPackage.length === 0) {
      return res
        .status(500)
        .json({ error: "User package information not found" });
    }

    const selectedPackage = userPackage[0];
    if (user.apiUseImagination >= selectedPackage.imagination) {
      return res
        .status(402)
        .json({ error: "Access limit exceeded for image generation" });
    }

    const CaptionImagesFolder = "./AllFile/ImaginationFile";

    
    const files = await fs.readdir(CaptionImagesFolder);

    if (files.length === 0) {
      return res
        .status(404)
        .json({ success: false, error: "No files found in the folder" });
    }

    const lastFile = files[files.length - 1];
    const imagePath = `${CaptionImagesFolder}/${lastFile}`;
    const chatImage = `ImaginationFile/${lastFile}`;

    const encodeImage = async (imagePath) => {
      const data = await fs.readFile(imagePath);
      return base64.fromByteArray(data);
    };

    const base64Image = await encodeImage(imagePath);

    const headers = {
      "Content-Type": "application/json",
      Authorization: `Bearer ${openai.apiKey}`,
    };

    const payload = {
      model: "gpt-4o",
      messages: [
        {
          role: "user",
          content: [
            {
              type: "text",
              text: `your target is make image imagination into imagery so for that need more information about image.must generate professional information about this image ${text} `,
            },
            {
              type: "image_url",
              image_url: {
                url: `data:image/jpeg;base64,${base64Image}`,
                detail: "high",
              },
            },
          ],
        },
      ],
      max_tokens: 2300,
    };

    const response = await axios.post(
      "https://api.openai.com/v1/chat/completions",
      payload,
      { headers }
    );
    const responseData = response.data;

    if (responseData.choices && responseData.choices.length > 0) {
      const messages = responseData.choices.map(
        (choice) => choice.message.content
      );
      const finalResult = messages[0];

      // Using OpenAI's images.generate method (assuming it exists in your OpenAI instance)
      const responseImage = await openai.images.generate({
        model: "dall-e-3",
        prompt: `Please give me an imagination into imagery picture of ${finalResult} and follow my instruction. Imagination into imagery following this instruction: ${text}`,
        size: "1024x1024",
        quality: "hd",
      });

      const imageUrl = responseImage.data[0].url;
      const imagePathSaved = `${Date.now()}.jpg`;
      const filePath = path.join(CaptionImagesFolder, imagePathSaved);

      const imageFile = await axios({
        url: imageUrl,
        method: "GET",
        responseType: "stream",
      });

      imageFile.data.pipe(fs.createWriteStream(filePath));

      const imageUrlSaved = `/ImaginationFile/${imagePathSaved}`;
      const timestamp = new Date().toISOString();

      await imaginationModel.create({
        text: finalResult,
        timestamp: timestamp,
        email: email,
        image: imageUrlSaved,
        chatImage: chatImage,
      });

      await userModel.findOneAndUpdate(
        { email },
        { $inc: { apiUseImagination: 1 } }
      );

      res.status(200).json({ success: true, messages: finalResult });
    } else {
      res.status(200).json({ success: false, error: "No messages found" });
    }
  } catch (error) {
    console.error(error);
    res
      .status(400)
      .json({ success: false, error: "The text could not be generated" });
  }
};

// const ImaginationImage = async (req, res) => {
//   try {
//     const apiKey = await getOpenAIKey();
//     const openai = new OpenAI({
//       apiKey: apiKey,
//     });
//     const { text } = req.body;
//     const { email } = req.headers;

//     const user = await userModel.findOne({ email });
//     if (!user) {
//       return res.status(400).json({ error: "User not found" });
//     }
//     const userPackage = await packageModel.aggregate([
//       {
//         $match: {
//           packageType: user.plan,
//           packageDuration: user.packageTime,
//         },
//       },
//     ]);

//     if (!userPackage || userPackage.length === 0) {
//       return res
//         .status(500)
//         .json({ error: "User package information not found" });
//     }

//     const selectedPackage = userPackage[0];
//     if (user.apiUseImagination >= selectedPackage.imagination) {
//       return res
//         .status(402)
//         .json({ error: "Access limit exceeded for image generation" });
//     }

//     const CaptionImagesFolder = "./AllFile/ImaginationFile";
//     fs.readdir(CaptionImagesFolder, async (err, files) => {
//       if (err) {
//         console.error(err);
//         return res
//           .status(500)
//           .json({ success: false, error: "Error reading image" });
//       }

//       // Ensure there are files in the folder
//       if (files.length === 0) {
//         return res
//           .status(404)
//           .json({ success: false, error: "No files found in the folder" });
//       }

//       const lastFile = files[files.length - 1];
//       const imagePath = `${CaptionImagesFolder}/${lastFile}`;
//       const chatImage = `ImaginationFile/${lastFile}`;

//       const encodeImage = (imagePath) => {
//         return new Promise((resolve, reject) => {
//           fs.readFile(imagePath, (err, data) => {
//             if (err) reject(err);
//             else resolve(base64.fromByteArray(data));
//           });
//         });
//       };
//       const base64Image = await encodeImage(imagePath);
//       const headers = {
//         "Content-Type": "application/json",
//         Authorization: `Bearer ${openai.apiKey}`,
//       };
//       const payload = {
//         model: "gpt-4o",
//         messages: [
//           {
//             role: "user",
//             content: [
//               {
//                 type: "text",
//                 text: `your target is make image imagination into imagery so for that need more information about image.must generate professional information about this image ${text} `,
//               },
//               {
//                 type: "image_url",
//                 image_url: {
//                   url: `data:image/jpeg;base64,${base64Image}`,
//                   detail: "high",
//                 },
//               },
//             ],
//           },
//         ],

//         max_tokens: 2300,
//       };
//       const response = await fetch(
//         "https://api.openai.com/v1/chat/completions",
//         {
//           method: "POST",
//           headers: headers,
//           body: JSON.stringify(payload),
//         }
//       );

//       const responseData = await response.json();
//       if (responseData.choices && responseData.choices.length > 0) {
//         const messages = responseData.choices.map(
//           (choice) => choice.message.content
//         );
//         const finalResult = messages[0];
//         const response = await openai.images.generate({
//           model: "dall-e-3",
//           prompt: `Please give me a imagination into imagery picture of ${finalResult} and fallow my instruction.imagination into imagery fallow by this instruction ${text}`,
//           size: "1024x1024",
//           quality: "hd",
//         });

//         const imageUrl = response.data[0].url;
//         const imagePath = `${Date.now()}.jpg`;

//         const filePath = path.join(CaptionImagesFolder, imagePath);
//         const file = fs.createWriteStream(filePath);
//         await new Promise((resolve, reject) => {
//           request
//             .get({ url: imageUrl })
//             .pipe(file)
//             .on("finish", resolve)
//             .on("error", reject);
//         });

//         const imageUrlSaved = `/ImaginationFile/${imagePath}`;
//         const timestamp = new Date().toISOString();

//         await imaginationModel.create({
//           text: finalResult,
//           timestamp: timestamp,
//           email: email,
//           image: imageUrlSaved,
//           chatImage: chatImage,
//         });

//         await userModel.findOneAndUpdate(
//           { email },
//           { $inc: { apiUseImagination: 1 } }
//         );
//         res.status(200).json({ success: true, messages: finalResult });
//       } else {
//         res.status(200).json({ success: false, error: "No messages found" });
//       }
//     });
//   } catch (error) {
//     console.error(error);
//     res
//       .status(400)
//       .json({ success: false, error: "The text could not be generated" });
//   }
// };

const captionImageDataList = async (req, res) => {
  try {
    const email = req.headers["email"];
    const pageNo = Number(req.params.pageNo);
    const perPage = Number(req.params.perPage);
    const searchValue = req.params.searchKeyword;
    const skipRow = (pageNo - 1) * perPage;
    const searchRgx = new RegExp(searchValue, "i");
    const matchStage = [
      {
        $match: {
          $or: [
            { url: searchRgx },
            { size: searchRgx },
            { email: searchRgx },
            { timestamp: searchRgx },
          ],
        },
      },
      {
        $addFields: {
          timestamp: {
            $toDate: "$timestamp",
          },
        },
      },
    ];

    const sortStage = {
      $sort: { timestamp: -1 },
    };

    const aggregationResult = await imaginationModel
      .aggregate([
        ...matchStage,
        sortStage,
        { $match: { email: email } },
        {
          $facet: {
            data: [{ $skip: skipRow }, { $limit: perPage }],
            total: [{ $count: "total" }],
          },
        },
      ])
      .exec();

    const data = aggregationResult[0].data || [];
    const totalCount = aggregationResult[0].total?.[0]?.total || 0;

    res.status(200).json({
      status: "success",
      data: { data, totalCount },
    });
  } catch (error) {
    console.error(error);
    res
      .status(500)
      .json({ status: "failed", error: error.message, data: null });
  }
};

const imaginationImageData = async (req, res) => {
  try {
    const { email } = req.headers;
    const data = await imaginationModel.find({ email });
    res.json(data);
  } catch (err) {
    console.error("Error fetching captioned images:", err);
    res.status(500).json({ error: "An error occurred while fetching data" });
  }
};
const deleteImaginationImage = async (req, res) => {
  const id = req.params.id;
  const Query = { _id: id };
  try {
    const data = await imaginationModel.deleteOne(Query);
    res
      .status(200)
      .json({ status: "success", message: "Delete successfully", data: data });
  } catch (error) {
    res
      .status(400)
      .json({ status: "error", message: "Not delete data", error: error });
  }
};

module.exports = {
  ImaginationImage,
  captionImageDataList,
  imaginationImageData,
  deleteImaginationImage,
};
