const fs = require("fs");
const base64 = require("base64-js");
// const fetch = require("node-fetch");
const OpenAI = require("openai");
const scratchToCodeSchemaModel = require("../DataModel/ScratchToCode");
const userModel = require("../DataModel/AuthDataModel");
const packageModel = require("../DataModel/packageModel");
const openAiApiModel = require("../DataModel/OpenAISettingModel");
async function getOpenAIKey() {
  try {
    const settings = await openAiApiModel.findOne();
    return settings ? settings.openAiAPI : null;
  } catch (error) {
    console.error("Error fetching OpenAI API key:", error);
    return null;
  }
}

const AIScratchCodeGenerate = async (req, res) => {
  debugger
  try {
    const apiKey = await getOpenAIKey();
    const openai = new OpenAI({
      apiKey: apiKey,
    });

    const { text, language } = req.body;
    const { email } = req.headers;

    const user = await userModel.findOne({ email });
    if (!user) {
      return res.status(400).json({ error: "User not found" });
    }

    const userPackage = await packageModel.aggregate([
      {
        $match: {
          packageType: user.plan,
          packageDuration: user.packageTime,
        },
      },
    ]);

    if (!userPackage || userPackage.length === 0) {
      return res.status(500).json({ error: "User package information not found" });
    }

    const selectedPackage = userPackage[0];
    if (user.apiUseScratchToCodeLimit >= selectedPackage.scratchToCodeLimit) {
      return res.status(402).json({ error: "Access limit exceeded for code generation" });
    }

    const CaptionImagesFolder = "./AllFile/ScratchFile";
    const files = await fs.readdir(CaptionImagesFolder);

    if (files.length === 0) {
      return res.status(404).json({ success: false, error: "No files found in the folder" });
    }
    const lastFile = files[files.length - 1];
    const imagePath = `${CaptionImagesFolder}/${lastFile}`;

    const encodeImage = async (imagePath) => {
      const data = await fs.readFile(imagePath);
      return base64.fromByteArray(data);
    };

    const base64Image = await encodeImage(imagePath);

    const headers = {
      "Content-Type": "application/json",
      Authorization: `Bearer ${openai.apiKey}`,
    };

    const payload = {
      model: "gpt-4-vision-preview",
      messages: [
        {
          role: "user",
          content: [
            {
              type: "text",
              text: `Your target is to generate code only. You will instruct as a software engineer. Describe this image with professionalism and very clearly.`,
            },
            {
              type: "image_url",
              image_url: {
                url: `data:image/jpeg;base64,${base64Image}`,
                detail: "high",
              },
            },
          ],
        },
      ],
      max_tokens: 2300,
    };

    const response = await axios.post(
      "https://api.openai.com/v1/chat/completions",
      payload,
      { headers }
    );

    const responseData = response.data;

    if (responseData.choices && responseData.choices.length > 0) {
      const messages = responseData.choices.map((choice) => choice.message.content);
      const finalResult = messages[0];

      const codeResponse = await openai.completions.create({
        model: "GPT-4o",
        prompt: `Your target is to generate code only. You are a software engineer. Must generate code only and CSS following this language: ${language}. This instruction is for code generation and CSS: ${text} and ${finalResult}. Make a complete code solution.`,
        max_tokens: 2000,
        temperature: 0.3,
      });

      const generatedCode = codeResponse.choices[0].text;
      const timestamp = new Date().toISOString();

      await scratchToCodeSchemaModel.create({
        text: generatedCode,
        timestamp: timestamp,
        email: email,
      });

      await userModel.findOneAndUpdate(
        { email },
        { $inc: { apiUseScratchToCodeLimit: 1 } }
      );

      res.status(200).json({ success: true, messages: generatedCode });
    } else {
      res.status(200).json({ success: false, error: "No messages found" });
    }
  } catch (error) {
    console.error(error);
    res.status(400).json({ success: false, error: "The text could not be generated" });
  }
};

// const AIScratchCodeGenerate = async (req, res) => {
//   const apiKey = await getOpenAIKey();
//   const openai = new OpenAI({
//     apiKey: apiKey,
//   });

//   const { text, language } = req.body;
//   const { email } = req.headers;

//   try {
//     const user = await userModel.findOne({ email });
//     if (!user) {
//       return res.status(400).json({ error: "User not found" });
//     }
//     const userPackage = await packageModel.aggregate([
//       {
//         $match: {
//           packageType: user.plan,
//           packageDuration: user.packageTime,
//         },
//       },
//     ]);
//     if (!userPackage || userPackage.length === 0) {
//       return res
//         .status(500)
//         .json({ error: "User package information not found" });
//     }
//     const selectedPackage = userPackage[0];
//     if (user.apiUseScratchToCodeLimit >= selectedPackage.scratchToCodeLimit) {
//       return res
//         .status(402)
//         .json({ error: "Access limit exceeded for audio generation" });
//     }

//     const CaptionImagesFolder = "./AllFile/ScratchFile";
//     fs.readdir(CaptionImagesFolder, async (err, files) => {
//       if (err) {
//         console.error(err);
//         return res
//           .status(500)
//           .json({ success: false, error: "Error reading image" });
//       }
//       if (files.length === 0) {
//         return res
//           .status(404)
//           .json({ success: false, error: "No files found in the folder" });
//       }

//       const lastFile = files[files.length - 1];
//       const imagePath = `${CaptionImagesFolder}/${lastFile}`;

//       const encodeImage = (imagePath) => {
//         return new Promise((resolve, reject) => {
//           fs.readFile(imagePath, (err, data) => {
//             if (err) reject(err);
//             else resolve(base64.fromByteArray(data));
//           });
//         });
//       };
//       const base64Image = await encodeImage(imagePath);
//       const headers = {
//         "Content-Type": "application/json",
//         Authorization: `Bearer ${openai.apiKey}`,
//       };
//       const payload = {
//         model: "gpt-4-vision-preview",
//         messages: [
//           {
//             role: "user",
//             content: [
//               {
//                 type: "text",
//                 text: `your target is make code generate only.You will instruction as like a software engineer. will describe with probationalizam this image and very clearly.`,
//               },
//               {
//                 type: "image_url",
//                 image_url: {
//                   url: `data:image/jpeg;base64,${base64Image}`,
//                   detail: "high",
//                 },
//               },
//             ],
//           },
//         ],
//         max_tokens: 2300,
//       };
//       const response = await fetch(
//         "https://api.openai.com/v1/chat/completions",
//         {
//           method: "POST",
//           headers: headers,
//           body: JSON.stringify(payload),
//         }
//       );
//       const responseData = await response.json();
//       if (responseData.choices && responseData.choices.length > 0) {
//         const messages = responseData.choices.map(
//           (choice) => choice.message.content
//         );
//         const finalResult = messages[0];
//         const response = await openai.completions.create({
//           model: "GPT-4o",
//           prompt: `your target is make code generate only .you are a software engineer.Must generate code only and CSS flow by this language ${language}.
//              this instruction for code generate and css ${text} and ${finalResult}.
//              make complete code solution`,
//           max_tokens: 2000,
//           temperature: 0.3,
//         });
//         const generatedCode = response.choices[0].text;
//         const timestamp = new Date().toISOString();
//         await scratchToCodeSchemaModel.create({
//           text: generatedCode,
//           timestamp: timestamp,
//           email: email,
//         });

//         await userModel.findOneAndUpdate(
//           { email },
//           { $inc: { apiUseScratchToCodeLimit: 1 } }
//         );
//         res.status(200).json({ success: true, messages: generatedCode });
//       } else {
//         res.status(200).json({ success: false, error: "No messages found" });
//       }
//     });
//   } catch (error) {
//     console.error(error);
//     res
//       .status(400)
//       .json({ success: false, error: "The text could not be generated" });
//   }
// };

const aiScratchCodeList = async (req, res) => {
  try {
    const email = req.headers["email"];
    const pageNo = Number(req.params.pageNo);
    const perPage = Number(req.params.perPage);
    const searchValue = req.params.searchKeyword;
    const skipRow = (pageNo - 1) * perPage;
    const searchRgx = new RegExp(searchValue, "i");
    const matchStage = [
      {
        $match: {
          $or: [
            { text: searchRgx },
            { email: searchRgx },
            { timestamp: searchRgx },
          ],
        },
      },
      {
        $addFields: {
          timestamp: {
            $toDate: "$timestamp",
          },
        },
      },
    ];

    const sortStage = {
      $sort: { timestamp: -1 },
    };

    const aggregationResult = await scratchToCodeSchemaModel
      .aggregate([
        ...matchStage,
        sortStage,
        { $match: { email: email } },
        {
          $facet: {
            data: [{ $skip: skipRow }, { $limit: perPage }],
            total: [{ $count: "total" }],
          },
        },
      ])
      .exec();
    const data = aggregationResult[0].data || [];
    const totalCount = aggregationResult[0].total?.[0]?.total || 0;

    res.status(200).json({
      status: "success",
      data: { data, totalCount },
    });
  } catch (error) {
    console.error(error);
    res
      .status(500)
      .json({ status: "failed", error: error.message, data: null });
  }
};
module.exports = { AIScratchCodeGenerate, aiScratchCodeList };
