const SMTPModel = require("../DataModel/SMTPModel");

const createOrUpdateSmtpInfo = async (req, res) => {
  try {
    const {
      smtpHost,
      smtpPort,
      smtpUserName,
      smtpPassword,
      smtpSenderEmail,
      smtpSenderName,
      smtpEncryption,
    } = req.body;

    const update = {
      smtpHost,
      smtpPort,
      smtpUserName,
      smtpPassword,
      smtpSenderEmail,
      smtpSenderName,
      smtpEncryption,
    };

    const updatedSmtpInfo = await SMTPModel.updateOne(update);

    if (!updatedSmtpInfo) {
      return res.status(404).json({
        status: "error",
        message: "SMTP information not found",
      });
    }

    res.status(200).json({
      message: "SMTP information updated successfully",
      data: updatedSmtpInfo,
    });
  } catch (error) {
    console.error("Error creating or updating SMTP information:", error);
    res.status(400).json({
      status: "error",
      message: "Failed to create or update SMTP information",
      error: error.message,
    });
  }
};

const getSmtpInfo = async (req, res) => {
  try {
    const result = await SMTPModel.findOne();

    if (!result) {
      return res.status(404).json({
        status: "error",
        message: "SMTP information not found",
      });
    }

    res.status(200).json({
      status: "success",
      message: "SMTP information retrieved successfully",
      data: result,
    });
  } catch (error) {
    console.error("Error retrieving SMTP information:", error);
    res.status(500).json({
      status: "error",
      message: "Failed to retrieve SMTP information",
      error: error.message,
    });
  }
};

module.exports = { createOrUpdateSmtpInfo, getSmtpInfo };
