const socialMediaModel = require("../DataModel/SocialMediaModel");

const socialMediaCreate = async (req, res) => {
  try {
    const { mediaLink, mediaIcon } = req.body;

    const carateData = await socialMediaModel.create({ mediaLink, mediaIcon });
    res.status(200).json({
      message: "SMTP information updated successfully",
      data: carateData,
    });
  } catch (error) {
    console.error("Error creating or updating SMTP information:", error);
    res.status(400).json({
      status: "error",
      message: "Failed to create or update SMTP information",
      error: error.message,
    });
  }
};

const getSmtpInfo = async (req, res) => {
  try {
    const result = await socialMediaModel.findOne();

    if (!result) {
      return res.status(404).json({
        status: "error",
        message: "SMTP information not found",
      });
    }

    res.status(200).json({
      status: "success",
      message: "SMTP information retrieved successfully",
      data: result,
    });
  } catch (error) {
    console.error("Error retrieving SMTP information:", error);
    res.status(500).json({
      status: "error",
      message: "Failed to retrieve SMTP information",
      error: error.message,
    });
  }
};
const readSocialMediaAdmin = async (req, res) => {
  try {
    const pageNo = Number(req.params.pageNo);
    const perPage = Number(req.params.perPage);
    const searchValue = req.params.searchKeyword;
    const skipRow = (pageNo - 1) * perPage;
    const searchRgx = new RegExp(searchValue, "i");
    const searchQuery =
      searchValue !== "0"
        ? {
            $or: [
              { orderId: searchRgx },
              { packageId: searchRgx },
              { name: searchRgx },
              { phone: searchRgx },
              { emailVal: searchRgx },
              { countryVal: searchRgx },
              { createDate: searchRgx },
              { packageTime: searchRgx },
              { packageType: searchRgx },
            ],
          }
        : {};

    const [totalCount, users] = await Promise.all([
      socialMediaModel.countDocuments(searchQuery),
      socialMediaModel.find(searchQuery).skip(skipRow).limit(perPage),
    ]);

    res.status(200).json({
      status: "success",
      data: { users, totalCount },
    });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
  }
};
const showHideSocialMedia = async (req, res) => {
  const { id, bullionData } = req.body;
  try {
    const matchId = { _id: id };

    const updateData = await socialMediaModel.updateOne(matchId, {
      $set: { active: bullionData },
    });
    if (updateData.nModified === 0) {
      return res.status(404).json({
        status: "failed",
        message: "User not found or no changes applied",
      });
    }
    res.status(200).json({ message: "Update successful" });
  } catch (error) {
    console.error("Error updating data:", error);
    res.status(500).json({
      status: "error",
      message: "An error occurred during data update",
    });
  }
};
const getAllSocialMedia = async (req, res) => {
  try {
    const data = await socialMediaModel.find({ active: true });
    res.status(200).json({ success: true, data });
  } catch (error) {
    console.error("Error in getAllAssistantUser:", error);
    res.status(500).json({ success: false, error: "Internal Server Error" });
  }
};

const deleteSocialMedia = async (req, res) => {
  const id = req.params.id;
  const Query = { _id: id };
  try {
    const data = await socialMediaModel.deleteOne(Query);
    res
      .status(200)
      .json({ status: "success", message: "Delete successfully", data: data });
  } catch (error) {
    res
      .status(400)
      .json({ status: "error", message: "Not delete data", error: error });
  }
};

const updateSocialMediaAdmin = async (req, res) => {
  const { updatedMediaLink, updatedMediaIcon, id } = req.body;
  try {
    const updateData = {
      mediaLink: updatedMediaLink,
      mediaIcon: updatedMediaIcon,
    };
    const data = await socialMediaModel.updateOne({ _id: id }, updateData);
    if (data.nModified > 0) {
      res.status(200).json({
        status: "success",
        message: "Update successful",
        data: data,
      });
    } else {
      res.status(404).json({
        status: "failed",
        message: "No matching document found to update",
        data: data,
      });
    }
  } catch (error) {
    res.status(500).json({
      status: "error",
      message: "Error updating social media data",
      error: error.message,
    });
  }
};

module.exports = {
  socialMediaCreate,
  getSmtpInfo,
  readSocialMediaAdmin,
  showHideSocialMedia,
  deleteSocialMedia,
  getAllSocialMedia,
  updateSocialMediaAdmin,
};
