const templateModel = require("../DataModel/templateModel");
const createTemplate = async (req, res) => {
  const {
    templateIcon,
    templateName,
    title,
    category,
    packageType,
    promptDescription,
    brandIcon,
  } = req.body;

  try {
    const package = await templateModel.create({
      templateIcon,
      templateName,
      title,
      category,
      packageType,
      promptDescription,
      brandIcon,
    });
    res.status(200).json({ status: "success", data: package });
  } catch (error) {
    res
      .status(500)
      .json({ status: "failed", message: "An error occurred", error: error });
    console.log(error);
  }
};
const updateTemplateData = async (req, res) => {
  try {
    const {
      id,
      templateIcon,
      templateName,
      title,
      category,
      packageType,
      promptDescription,
      brandIcon,
    } = req.body;

    const updateTemplateData = {
      id: id,
      templateIcon: templateIcon,
      templateName: templateName,
      title: title,
      category: category,
      packageType: packageType,
      promptDescription: promptDescription,
      brandIcon: brandIcon,
    };
    const data = await templateModel.findByIdAndUpdate(id, updateTemplateData, {
      new: true,
    });
    res.status(200).json({ message: "success", data: data });
  } catch (error) {
    console.error("Error updating blog post:", error);
    res.status(400).json({
      status: "error",
      message: "Failed to update data",
      error: error,
    });
  }
};
const templateListAdmin = async (req, res) => {
  try {
    const pageNo = Number(req.params.pageNo);
    const perPage = Number(req.params.perPage);
    const searchValue = req.params.searchKeyword;
    const skipRow = (pageNo - 1) * perPage;
    const searchRgx = new RegExp(searchValue, "i");
    const searchQuery =
      searchValue !== "0"
        ? {
            $or: [
              { orderId: searchRgx },
              { packageId: searchRgx },
              { name: searchRgx },
              { phone: searchRgx },
              { emailVal: searchRgx },
              { countryVal: searchRgx },
              { createDate: searchRgx },
              { packageTime: searchRgx },
              { packageType: searchRgx },
            ],
          }
        : {};

    const [totalCount, users] = await Promise.all([
      templateModel.countDocuments(searchQuery),
      templateModel.find(searchQuery).skip(skipRow).limit(perPage),
    ]);

    res.status(200).json({
      status: "success",
      data: { users, totalCount },
    });
  } catch (error) {
    res.status(500).json({ status: "failed", error: error.message });
  }
};
const showHideTemplate = async (req, res) => {
  const { id, bullionData } = req.body;
  try {
    const matchId = { _id: id };

    const updateData = await templateModel.updateOne(matchId, {
      $set: { active: bullionData },
    });
    if (updateData.nModified === 0) {
      return res.status(404).json({
        status: "failed",
        message: "User not found or no changes applied",
      });
    }
    res.status(200).json({ message: "Update successful" });
  } catch (error) {
    console.error("Error updating data:", error);
    res.status(500).json({
      status: "error",
      message: "An error occurred during data update",
    });
  }
};
const deleteTemplate = async (req, res) => {
  const id = req.params.id;
  const Query = { _id: id };
  try {
    const data = await templateModel.deleteOne(Query);
    res
      .status(200)
      .json({ status: "success", message: "Delete successfully", data: data });
  } catch (error) {
    res
      .status(400)
      .json({ status: "error", message: "Not delete data", error: error });
  }
};
const getAllTemplateUser = async (req, res) => {
  try {
    const data = await templateModel.find({ active: "true" });
    const commonTemplate = data.filter((item) => item.category === "common");
    const articleTemplate = data.filter((item) => item.category === "article");
    const socialMediaTemplate = data.filter(
      (item) => item.category === "socialMedia"
    );
    const economicsTemplate = data.filter(
      (item) => item.category === "economics"
    );
    const emailTemplate = data.filter((item) => item.category === "email");
    const websiteTemplate = data.filter((item) => item.category === "website");
    const blogPostTemplate = data.filter(
      (item) => item.category === "blogPost"
    );
    const marketingTemplate = data.filter(
      (item) => item.category === "marketing"
    );
    res.status(200).json({
      success: true,
      commonTemplate,
      articleTemplate,
      socialMediaTemplate,
      economicsTemplate,
      emailTemplate,
      websiteTemplate,
      blogPostTemplate,
      marketingTemplate,
    });
  } catch (error) {
    res.status(500).json({ success: false, message: "Internal Server Error" });
  }
};
const getSingleTemplateData = async (req, res) => {
  const id = req.params.id;
  try {
    const data = await templateModel.findById(id);
    if (!data) {
      return res
        .status(404)
        .json({ status: "error", message: "Data not found" });
    }
    res.status(200).json({
      status: "success",
      message: "Data found successfully",
      data: data,
    });
  } catch (error) {
    res
      .status(400)
      .json({ status: "error", message: "Failed to fetch data", error: error });
  }
};
const setFavoriteData = async (req, res) => {
  const favoriteData = req.body.favoriteData;
  const id = req.body.id;
  try {
    const matchId = { _id: id };
    const updateData = await templateModel.updateOne(matchId, {
      $set: { favorite: favoriteData },
    });
    if (updateData.nModified === 0) {
      return res.status(404).json({
        status: "failed",
        message: "User not found or no changes applied",
      });
    }
    res.status(200).json({ message: "Update successful" });
  } catch (error) {
    console.error("Error updating data:", error);
    res.status(500).json({
      status: "error",
      message: "An error occurred during data update",
    });
  }
};

const getAllFavoriteTemplate = async (req, res) => {
  try {
    const data = await templateModel.find({ favorite: "like" });
    res.status(200).json({ success: true, data: data });
  } catch (error) {
    res.status(500).json({ success: false, message: "Internal Server Error" });
  }
};

module.exports = {
  createTemplate,
  templateListAdmin,
  showHideTemplate,
  updateTemplateData,
  deleteTemplate,
  getAllTemplateUser,
  getSingleTemplateData,
  setFavoriteData,
  getAllFavoriteTemplate,
};
