const fs = require("fs");
const path = require("path");
const base64 = require("base64-js");
// const fetch = require("node-fetch");
const OpenAI = require("openai");
const axios = require('axios');
const visionModel = require("../DataModel/VisionModel");
const userModel = require("../DataModel/AuthDataModel");
const packageModel = require("../DataModel/packageModel");
const openAiApiModel = require("../DataModel/OpenAISettingModel");
async function getOpenAIKey() {
  try {
    const settings = await openAiApiModel.findOne();
    return settings ? settings.openAiAPI : null;
  } catch (error) {
    console.error("Error fetching OpenAI API key:", error);
    return null;
  }
}

const visionImage = async (req, res) => {
  const apiKey = await getOpenAIKey();
  const openai = new OpenAI({
    apiKey: apiKey,
  });
  const { descriptionValue, selectedLanguage } = req.body;
  const email = req.headers.email;
  try {
    const user = await userModel.findOne({ email });
    if (!user) {
      return res.status(400).json({ error: "User not found" });
    }
    const userPackage = await packageModel.aggregate([
      {
        $match: {
          packageType: user.plan,
          packageDuration: user.packageTime,
        },
      },
    ]);
    if (!userPackage || userPackage.length === 0) {
      return res
        .status(500)
        .json({ error: "User package information not found" });
    }
    const selectedPackage = userPackage[0];
    if (user.apiUseAiVisionLimit >= selectedPackage.aiVisionLimit) {
      return res
        .status(402)
        .json({ error: "Access limit exceeded for audio generation" });
    }
    const Vision_FOLDER = "./AllFile/Vision_image";
    fs.readdir(Vision_FOLDER, async (err, files) => {
      if (err) {
        console.error(err);
        return res
          .status(500)
          .json({ success: false, error: "Error reading image" });
      }

      const imagePath = `${Vision_FOLDER}/${files[0]}`;

      const encodeImage = (imagePath) => {
        return new Promise((resolve, reject) => {
          fs.readFile(imagePath, (err, data) => {
            if (err) reject(err);
            else resolve(base64.fromByteArray(data));
          });
        });
      };
      const base64Image = await encodeImage(imagePath);
      const headers = {
        "Content-Type": "application/json",
        Authorization: `Bearer ${openai.apiKey}`,
      };
      const payload = {
        model: "gpt-4-vision-preview",
        messages: [
          {
            role: "user",
            content: [
              {
                type: "text",
                text: `${descriptionValue} must you will give me this language text ${selectedLanguage}`,
              },
              {
                type: "image_url",
                image_url: {
                  url: `data:image/jpeg;base64,${base64Image}`,
                },
              },
            ],
          },
        ],
        max_tokens: 1200,
      };
      const response = await axios.post(
        "https://api.openai.com/v1/chat/completions",
        payload,
        { headers: headers }
      );

      const responseData = response.data;

      if (responseData.choices && responseData.choices.length > 0) {
        const messages = responseData.choices.map(
          (choice) => choice.message.content
        );
        const finalResult = messages[0];
        const timestamp = new Date().toISOString();

        await visionModel.create({
          text: finalResult,
          timestamp: timestamp,
          email: email,
        });

        await userModel.findOneAndUpdate(
          { email },
          { $inc: { apiUseAiVisionLimit: 1 } }
        );

        // Delete the content of the folder
        files.forEach((file) => {
          const filePath = path.join(Vision_FOLDER, file);
          fs.unlinkSync(filePath);
        });

        res.status(200).json({ success: true, messages: finalResult });
      } else {
        res.status(200).json({ success: false, error: "No messages found" });
      }
    });
  } catch (error) {
    console.error(error);
    res
      .status(400)
      .json({ success: false, error: "The text could not be generated" });
  }
};


// const visionImage = async (req, res) => {
//   const apiKey = await getOpenAIKey();
//   const openai = new OpenAI({
//     apiKey: apiKey,
//   });
//   const { descriptionValue, selectedLanguage } = req.body;
//   const email = req.headers.email;
//   try {
//     const user = await userModel.findOne({ email });
//     if (!user) {
//       return res.status(400).json({ error: "User not found" });
//     }
//     const userPackage = await packageModel.aggregate([
//       {
//         $match: {
//           packageType: user.plan,
//           packageDuration: user.packageTime,
//         },
//       },
//     ]);
//     if (!userPackage || userPackage.length === 0) {
//       return res
//         .status(500)
//         .json({ error: "User package information not found" });
//     }
//     const selectedPackage = userPackage[0];
//     if (user.apiUseAiVisionLimit >= selectedPackage.aiVisionLimit) {
//       return res
//         .status(402)
//         .json({ error: "Access limit exceeded for audio generation" });
//     }
//     const Vision_FOLDER = "./AllFile/Vision_image";
//     fs.readdir(Vision_FOLDER, async (err, files) => {
//       if (err) {
//         console.error(err);
//         return res
//           .status(500)
//           .json({ success: false, error: "Error reading image" });
//       }

//       const imagePath = `${Vision_FOLDER}/${files[0]}`;

//       const encodeImage = (imagePath) => {
//         return new Promise((resolve, reject) => {
//           fs.readFile(imagePath, (err, data) => {
//             if (err) reject(err);
//             else resolve(base64.fromByteArray(data));
//           });
//         });
//       };
//       const base64Image = await encodeImage(imagePath);
//       const headers = {
//         "Content-Type": "application/json",
//         Authorization: `Bearer ${openai.apiKey}`,
//       };
//       const payload = {
//         model: "gpt-4-vision-preview",
//         messages: [
//           {
//             role: "user",
//             content: [
//               {
//                 type: "text",
//                 text: `${descriptionValue} must you will give me this language text ${selectedLanguage}`,
//               },
//               {
//                 type: "image_url",
//                 image_url: {
//                   url: `data:image/jpeg;base64,${base64Image}`,
//                 },
//               },
//             ],
//           },
//         ],
//         max_tokens: 1200,
//       };
//       const response = await fetch(
//         "https://api.openai.com/v1/chat/completions",
//         {
//           method: "POST",
//           headers: headers,
//           body: JSON.stringify(payload),
//         }
//       );

//       const responseData = await response.json();

//       if (responseData.choices && responseData.choices.length > 0) {
//         const messages = responseData.choices.map(
//           (choice) => choice.message.content
//         );
//         const finalResult = messages[0];
//         const timestamp = new Date().toISOString();

//         await visionModel.create({
//           text: finalResult,
//           timestamp: timestamp,
//           email: email,
//         });

//         await userModel.findOneAndUpdate(
//           { email },
//           { $inc: { apiUseAiVisionLimit: 1 } }
//         );

//         // Delete the content of the folder
//         files.forEach((file) => {
//           const filePath = path.join(Vision_FOLDER, file);
//           fs.unlinkSync(filePath);
//         });

//         res.status(200).json({ success: true, messages: finalResult });
//       } else {
//         res.status(200).json({ success: false, error: "No messages found" });
//       }
//     });
//   } catch (error) {
//     console.error(error);
//     res
//       .status(400)
//       .json({ success: false, error: "The text could not be generated" });
//   }
// };

const visionCountUserDashboard = async (req, res) => {
  const email = req.headers["email"];
  const currentYear = new Date().getFullYear();
  try {
    const result = await visionModel
      .aggregate([
        {
          $match: {
            email: email,
            timestamp: {
              $regex: `^${currentYear}`,
            },
          },
        },
        {
          $group: {
            _id: { $month: { $toDate: "$timestamp" } },
            text: { $sum: 1 },
          },
        },
      ])
      .exec();
    const monthlyCounts = Array(12).fill(0);
    result.forEach((item) => {
      const monthIndex = item._id - 1;
      monthlyCounts[monthIndex] = item.text;
    });
    res.status(200).json({
      status: "success",
      monthlyCounts: monthlyCounts,
    });
  } catch (error) {
    console.error(error);
    res.status(500).json({ status: "failed", error: error.message });
  }
};

const allVisionTableData = async (req, res) => {
  try {
    const email = req.headers["email"];
    const pageNo = Number(req.params.pageNo);
    const perPage = Number(req.params.perPage);
    const searchValue = req.params.searchKeyword;
    const skipRow = (pageNo - 1) * perPage;
    const searchRgx = new RegExp(searchValue, "i");
    const matchStage = [
      {
        $match: {
          $or: [
            { url: searchRgx },
            { size: searchRgx },
            { email: searchRgx },
            { timestamp: searchRgx },
          ],
        },
      },
      {
        $addFields: {
          timestamp: {
            $toDate: "$timestamp",
          },
        },
      },
    ];

    const sortStage = {
      $sort: { timestamp: -1 },
    };

    const aggregationResult = await visionModel
      .aggregate([
        ...matchStage,
        sortStage,
        { $match: { email: email } },
        {
          $facet: {
            data: [{ $skip: skipRow }, { $limit: perPage }],
            total: [{ $count: "total" }],
          },
        },
      ])
      .exec();

    const data = aggregationResult[0].data || [];
    const totalCount = aggregationResult[0].total?.[0]?.total || 0;

    res.status(200).json({
      status: "success",
      data: { data, totalCount },
    });
  } catch (error) {
    console.error(error);
    res
      .status(500)
      .json({ status: "failed", error: error.message, data: null });
  }
};
const deleteVisionData = async (req, res) => {
  const id = req.params.id;
  const Query = { _id: id };
  try {
    const data = await visionModel.deleteOne(Query);
    res
      .status(200)
      .json({ status: "success", message: "Delete successfully", data: data });
  } catch (error) {
    res
      .status(400)
      .json({ status: "error", message: "Not delete data", error: error });
  }
};

module.exports = {
  visionImage,
  visionCountUserDashboard,
  allVisionTableData,
  deleteVisionData,
};
