const puppeteer = require("puppeteer");
const fs = require("fs");
const path = require("path");
const base64 = require("base64-js");
const axios = require('axios');
// const fetch = require("node-fetch");
const OpenAI = require("openai");
const userModel = require("../DataModel/AuthDataModel");
const packageModel = require("../DataModel/packageModel");
const openAiApiModel = require("../DataModel/OpenAISettingModel");

// Function to asynchronously retrieve OpenAI API key
async function getOpenAIKey() {
  try {
    const settings = await openAiApiModel.findOne();
    return settings ? settings.openAiAPI : null;
  } catch (error) {
    console.error("Error fetching OpenAI API key:", error);
    return null;
  }
}

const Vision_FOLDER = "./AllFile/screenshots";
// const WebScripting = async (req, res) => {
//   const apiKey = await getOpenAIKey();
//   const openai = new OpenAI({
//     apiKey: apiKey,
//   });
//   const { fileData } = req.body;
//   const email = req.headers.email;

//   try {
//     const user = await userModel.findOne({ email });
//     if (!user) {
//       return res.status(400).json({ error: "User not found" });
//     }
//     const userPackage = await packageModel.aggregate([
//       {
//         $match: {
//           packageType: user.plan,
//           packageDuration: user.packageTime,
//         },
//       },
//     ]);
//     if (!userPackage || userPackage.length === 0) {
//       return res.status(500).json({ error: "User package information not found" });
//     }
//     const selectedPackage = userPackage[0];
//     if (user.apiUseWebScriptingLimit >= selectedPackage.webScriptingLimit) {
//       return res.status(402).json({ error: "Access limit exceeded for audio generation" });
//     }
    
//     const browser = await puppeteer.launch({
//       headless: false,
//     });
//     const page = await browser.newPage();
//     await page.setViewport({
//       width: 1900,
//       height: 1600,
//       deviceScaleFactor: 1,
//     });

//     await page.goto(fileData);
//     const imagePath = path.join(__dirname, "screenshot.png");
//     await page.screenshot({ path: imagePath });

//     const encodeImage = async (imagePath) => {
//       const data = await fs.readFile(imagePath);
//       return base64.fromByteArray(data);
//     };
    
//     const base64Image = await encodeImage(imagePath);
    
//     const headers = {
//       "Content-Type": "application/json",
//       Authorization: `Bearer ${openai.apiKey}`,
//     };
    
//     const payload = {
//       model: "gpt-4-vision-preview",
//       messages: [
//         {
//           role: "system",
//           content: "You will start with a formal greeting, no need to say about source of screenshot and then you will analyze and give more professional article about this screenshot",
//         },
//         {
//           role: "user",
//           content: [
//             {
//               type: "text",
//               text: "Must you will give me this language text",
//             },
//             {
//               type: "image_url",
//               image_url: {
//                 url: `data:image/jpeg;base64,${base64Image}`,
//               },
//             },
//           ],
//         },
//       ],
//       max_tokens: 3000,
//     };
    
//     const response = await axios.post("https://api.openai.com/v1/chat/completions", payload, { headers });

//     const responseData = response.data;

//     if (responseData.choices && responseData.choices.length > 0) {
//       const messages = responseData.choices.map((choice) => choice.message.content);
//       const finalResult = messages[0].toString();

//       await userModel.findOneAndUpdate(
//         { email },
//         { $inc: { apiUseWebScriptingLimit: 1 } }
//       );

//       await fs.unlink(imagePath);
//       res.status(200).json({ success: true, messages: finalResult });
//     }
    
//     await browser.close();
//   } catch (err) {
//     console.log("An error occurred: ", err);
//     res.status(500).send({ error: "An error occurred while processing." });
//   }
// };

const WebScripting = async (req, res) => {
  const apiKey = await getOpenAIKey();
  const openai = new OpenAI({
    apiKey: apiKey,
  });
  const { fileData } = req.body;
  const email = req.headers.email;

  try {
    const user = await userModel.findOne({ email });
    if (!user) {
      return res.status(400).json({ error: "User not found" });
    }
    const userPackage = await packageModel.aggregate([
      {
        $match: {
          packageType: user.plan,
          packageDuration: user.packageTime,
        },
      },
    ]);
    if (!userPackage || userPackage.length === 0) {
      return res
        .status(500)
        .json({ error: "User package information not found" });
    }
    const selectedPackage = userPackage[0];
    if (user.apiUseWebScriptingLimit >= selectedPackage.webScriptingLimit) {
      return res
        .status(402)
        .json({ error: "Access limit exceeded for audio generation" });
    }
    const browser = await puppeteer.launch({
      headless: false,
    });
    const page = await browser.newPage();
    await page.setViewport({
      width: 1900,
      height: 1600,
      deviceScaleFactor: 1,
    });

    await page.goto(fileData);
    const imagePath = path.join(Vision_FOLDER, "screenshot.png");
    await page.screenshot({ path: imagePath });

    const encodeImage = (imagePath) => {
      return new Promise((resolve, reject) => {
        fs.readFile(imagePath, (err, data) => {
          if (err) reject(err);
          else resolve(base64.fromByteArray(data));
        });
      });
    };
    const base64Image = await encodeImage(imagePath);
    const headers = {
      "Content-Type": "application/json",
      Authorization: `Bearer ${openai.apiKey}`,
    };
    const payload = {
      model: "gpt-4-vision-preview",
      messages: [
        {
          role: "system",
          content:
            "You will start with a formal greeting no need to say about source of screenshot and then you will analyses and give more professionals article about this screenshot",
        },
        {
          role: "user",
          content: [
            {
              type: "text",
              text: `Must you will give me this language text`,
            },
            {
              type: "image_url",
              image_url: {
                url: `data:image/jpeg;base64,${base64Image}`,
              },
            },
          ],
        },
      ],
      max_tokens: 3000,
    };
    const response = await axios.post("https://api.openai.com/v1/chat/completions", payload, { headers });
   
    // const response = await fetch("https://api.openai.com/v1/chat/completions", {
    //   method: "POST",
    //   headers: headers,
    //   body: JSON.stringify(payload),
    // });

    const responseData = await response.data;
debugger
    if (responseData.choices && responseData.choices.length > 0) {
      const messages = responseData.choices.map(
        (choice) => choice.message.content
      );
      const finalResult = messages[0].toString();

      await userModel.findOneAndUpdate(
        { email },
        { $inc: { apiUseWebScriptingLimit: 1 } }
      );

      fs.unlinkSync(imagePath);
      res.status(200).json({ success: true, messages: finalResult });
    }
    await browser.close();
  } catch (err) {
    console.log("An error occurred: ", err);
    res.status(500).send({ error: "An error occurred while processing." });
  }
};

module.exports = { WebScripting };
