const mongoose = require("mongoose");
const AiAssistantSchema = mongoose.Schema(
  {
    assistantIcon: { type: String },
    assistantName: { type: String },
    matchId: { type: String },
    title: { type: String },
    packageType: { type: String },
    category: { type: String },
    promptDescription: { type: String },
    brandIcon: { type: String },
    position: { type: Number },
    selectedModel: { type: String, default: "gpt-4-0125-preview" },
    token: { type: Number, default: 500 },
    randomness: { type: Number, default: 0.5 },
    frequencyPenalty: { type: Number, default: 0.8 },
    presencePenalty: { type: Number, default: 0.7 },
    last_chat: [
      {
        message: { type: String },
        sender: { type: String, default: "chatGpt" },
        sendTime: { type: Date, default: Date.now() },
        email: { type: String },
        inputValue: { type: String },
      },
    ],
    active: { type: String, default: false },
    favorite: { type: String, default: "dislike" },
    createDate: { type: Date, default: Date.now() },
  },
  { versionKey: false }
);

// Pre-save hook to ensure default values for `last_chat` field
AiAssistantSchema.pre("save", function (next) {
  if (!this.last_chat || this.last_chat.length === 0) {
    this.last_chat.push({
      message: "Hello welcome to Rapid AI",
      sender: "chatGpt",
      sendTime: new Date(),
    });
  }
  next();
});

const AiAssistantModel = mongoose.model("AiAssistant", AiAssistantSchema);
module.exports = AiAssistantModel;
