const mongoose = require("mongoose");
const authData = mongoose.Schema(
  {
    name: {
      type: String,
    },
    userName: {
      type: String,
    },
    email: {
      type: String,
      unique: true,
      require: true,
    },
    image: {
      type: String,
      default:
        "data:image/jpeg;base64,/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/2wBDAQMEBAUEBQkFBQkUDQsNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBT/wAARCADsANADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD9M8e9L+NJn2peKsgWjNHFHFABmjNHFKKAE704dKPel+nTvS2DpcKPSqt3qlrZRkzTJGV7Fhn8uv6VhyfEDSoWkxJJlDgny22/XdjFS5RW7NFTlLZHS5z0B+uP8n9Kbkk9CfoM15Pr3xi8PXEUqNeXNwsbYdNOdkP/AAJ15H5ivJ9e+JulXAeOPU7vSl3bt8tw7Mo9SS+fzzXJPFwhszqp4KpU3R9XfaEVtpZc/wC8Kk3fzr5CX4g6sti95aa9cXFunHnq0dynbk4HAx1yB1A5JrGuv2j/ABT4VunMmqWt3Er+XtkiSIH3ZQFAOeMbgeOnesVmEb2kjpeXTtoz7X56449aOfQ18weEf2lPEXiZvs9kmkXmo7grWd5ut5eem1tz7+eMLk8jGRzXpVv8YNS0+2jk1rw5N8v+tayIfBxyEU4dz7bQfauunWjU1RwzoTpuzPU2x25pOK53wz8QdD8XAjTb1ZZ1UF7eT5ZUz2Zeo9Prx1yK6IkMenJ7V0XT2OdqwcUhHel4pCe1MBKKKKBDW9aSn009aAEptLupKAJaM+1FFAC8UvFIMUvFABxSjoT2FN4rP8QeItP8K6TcalqlytrZW67pJGPTnj8aV7DtrYb4i8Taf4T0977UrlbW3UcvJn86+R/2gP2z7S30ZLPwbqTnUJWZZ5IYyZIY+cEAjgtjjrwQak+Nn7TXh/xxo9x4fjRSsoMkV5MGVI3Tk847j/8AUa+d9Q+K3jP4e3VuG0RNWsrt9kMltdeanGcDlAD1Jxwx9K8uviZRfLDU9rD4KLhzz3KsfxW8aeML+3z/AGvIJI8C8ijlDgdctlR+Yx9K7vRJ/HE1thhd6lI3zFby1eXKgf3kjLe3Ncpp3xm1bXtYCamkPh5HT5Hk0JjHHj/bdm2t7kL9K6TUNB8TeKrKW407V9L8QQlNypNZvPCT2LMkZXp6nI9K8mTbep7UIpLQx/FWvX3h9UkvvDlxp7sN32i3nAVD/uS7MD6K1cRefHH7UWsJpJZS4+WQur7cDqV6Ff8AbIJHQEAAUzW28ZeH/NtbrQ7wW7th/wCzEF1GxxnHknAKgdipYDoK8c8R3Wma4JVy9rcIfm8xB5Q5xkocvHzwCDgd0FXTpxk/eM6tRw+E9X034nS2F7v0+8bTJlyZFjclQAp/eBv41wctGRngFWUkg3te8ZXnje01Aw28Gna7ZbpLmxUYjvAGwzJ7jn5SMcDGM187xtfRXkUJcx3CDdDdSSBcY7lskdB9/wBsEACu+tNWa4uNK1OJ/JveI1C/KTLEq/Kw6cqu3acZwK63h1HVHLHEuXust6XrNxdN9r05jbX8WX8raFDkZ3DHpzgg8jLHJ617T4V/aS8XaFpkF7DeyanppURXWn3zncqgjBWQfMDjI5BHy4x0z4Z4wK+HdQk1S1ClYHWZGK8XduxOwH1OQ0Z9wPU5r/8ACaWlnJdBnxZ3rb2467ge/wCCnnuM1cYNaxMZST0kfZ2ifEb/AIW9Jaap4Y1JbDxRbuI7K8mgxdRuclbadQ+yaJwMcj5eo9K9S8B/tcMLVYvE2m/YL2CY2l3ZmT94ky8Mqb8bsYyASCR0zwD+Z1l4uk0HxCj2M0lk0kI8qWPCsHDKDg46hq9m+G/xeT4qeINQg12Gwa51a3WG4aSMCOR9hVXK9PMBwwbseR3zveUNTBxhPQ/VPwv460HxpbibR9Utr8bQzJE43oCONyH5lPqCAR3rdI545+ma/JHw54p1bwt4lkl0XUGstXtbny9M1BX2r5gbAgmUnmNwCBnO3hRmv0P/AGavjnB8cPBct7Iq2utWUzW19abshJAM5HtwR+FdVGtzaSOKvh3Td1sevUUuB60ldJxhTW606k20CGbaSnUm2gCSiilHSgAGKOKXik/iAFAxwxsY18i/tnal4k0+9sLeQrqPh+6z5VjHw6sE+Z25GRXt/wAbPi8vwj0AX/2Q31xMTHDbqTuZtpPAwcgcZzgDPWvg74nfFjWvjfNC3iJ5NPeFtttHp8YO0FgGwSwDnB/h5AGcEHNcVesrcp3YWi5T5nscr/Ztzo/jC01yaxnm0iGIKLUAtsVkKyBkySy/Mfzztq/odjqfgmRJoru3174fXwL2zXgbfbDqVEgBRlBypVsEYGO4GPpHji88HtdadFFHqW0s0cJIn84DAYj5vmIByQckAkgfLirnhn9o/wAOaT9qtxY/2dFdOftltuQQ7ifvYchHGCMhio6Zw2DXiyUz6GHs46RdmdH4kXQ9e01r7QJUstQtSqZhMcM6k8iJlI3gjsmzcccBxzXh3jDx54n8N6wk2o3ixampzFcLAlrIo7FpYQu4kY7HPcrmtrxpZ+Hrq8/tLT7z+ylkbEF1Zq09sw6bQFKyx4xgqGc5B6dK5N4dcbzRa6nb615h3NHHdruYe8Uhzjt8wyPUGqpRV9SKnNbQmuv2r/Gtmxh1VrbWoIjhk1a0VZlGehdcHHpuyfc9K1dP+ImifF5ja3Dpo+rEbooLqXzEk9dkhyQxH8OeO4UYNeb61osX2h1ubGbR5wudio0QKnuEyFYAd1wMY5NcHrWmy6LMpilihXIeG5t2JhfHQg9j1GO2TgivQVGm1eKszz5VakX77uj2fX7BdEs5rS5LLA5ZWZ/4Ahy6hjuK9V9funbkbq83ury70mS8tHl3YYSwSqAB5kY+XjOOg29/vAZOMnSvvGVxrXhO0vbgBp13Q3SKpXzAn3d3J5GRgjtx71w86ytetbrIxt8qFk3DIAxx+BH6D0rSmtLSM6kle8T0i38VL4s8Ez6dLLmQxSwrzklNokjX8HH615zJrj3Wg2yMB8pU7QeoDDjHXpU+ix3lnfW/kxtjqTjqc/8A1qpPoV19peQxNGCWKIRwq89/x/StYRjHqZScpW0LepX00K2dyWLnCkNgkF8qT9DkdKt+DvEzaPfIxLqY/nbb1BGCPoc5596sWPh66vLae0kG+3I3AqGJDYzkfTI79qwL/TRY3U6SbhhQA7gjcevTHpVc0XoZSjOLue5r8RLfWzNqN1shubiHdNsGMyhDtYccHcA3sW9q94/Y/wDi0PAvxn064kvFOj69mwvlUYUSkjbIR0+9yfrXwe+s3Zj8iKRmZwVZscL6flx+Vd38PvGT+H9Ws5pmFxBbSK8kasyttLA4VsEZ+Tr2xWbpWd0bKtzRcGfv9bzR3USyQsskTDKMpyCO36U7H4V4T+yd8Vrb4kfDa1uEumuLgXc4FvIQ00UZZnjD4Ax8jJjjoRXu/A44OOOmOldcXoeZJcrsNo7UGiqEM6UU4jvTaYh9GfajHvR3oAXilYqEOTtHc+x/rRxXlX7R3xIj+Hvw6u5IrkQX13/o8JGCRn7xxn071EnyxbLjH2klFHyT+3V4i0bxxr9lY6BeXL3OnCSK6mLlonbIIRAxC8EHnIAJPGevyxqnjeG108mCSWz1IDY02fMSXByVkKjOSR1OR6EV1+u+ItAtmmdNMmvLuZyxnuiAM56g7jknr0I56V55r2jaj4iZp54BbRAbkeeQMUA4+UAA88Yzxk49K8fn53dnvRp8iUYnG694wl1y7ZmD2g3+Y8UgPlBh0dHAbHBI6ZwcZpc3OrW8mYm1IgAea0gEm3r1GC//AALK/wCzXd+AfhJf+K7xFFoYbJTujWYffP8AfOe+c8cj04r6E8M/sqq3lOlqkch585VA784GOKxqYqEHZHfSwUprmlofIeiRX2l+Zc6U19ZySNgwMRLBKAAMMNo5HTPUYxW1JNaaihiv7ZtJuQTtmERaFjnuq8g5/i4P161+hGg/sx6ZaW6PPALiXHJYAD8q1p/2edAuWLPpsMR9UwD/AC/nXJ9Zu/hO6GGilbnPzN1LXNf0mL7LO39o6e2CnmfvlAB4wT8y/gc571ijRJtUnLwRs1vdE+bbnnDddw9896/TW8/ZX8OXqMsViEVuvAwaxl/ZR0nTbxJoUSML/Co4qvrnL9kz+oxnK3MfDXg/4O6tqNiLS1tJm8197AqTggcH+tekeG/2P9UaRZLiP93jpx3Ar7d8P/Dm18PwxrHEMAfeUc10UekhcBU3DGMkVg8XVlezsdUcFRg9rnyZp37LENvHkxxmYMNuf4V/yal8Qfsy2a2IWC3Mz42sRwDX1nHowGdy7fepJdPRUK7VdfYVl7Sb6nV7Kl/KfGGj/sxPaqZJcwwjkAKCfzrnPiV8CY7nT5Bb2jQtEPkcBW9gccce9fdLaVbPGRs4PY1ial4Zt7hWj8sFGXa2QOmc4/Omq1SLuiXRpTi4NH43+NPDt74d1CaGRJofLYq23hQf8KyNFthdahBCLgRzHJXeuVJPueK/Qn4/fAWz1DT7vUIrfE0MTMwVeJBgnGPwr4Tu/CY0/wAQXFnHIz+WWaKRTtLL1VlHOcDHFfRYXEKtGz3R8hjcD9XndbHtn7P/AMetZ+G/jSyiTUIlhN3CZ7eZzHHhMKwGzGfkJHPZs9q/bHw7rMPiDRbO/gkilSeFJd0T71wR1B7j8q/nQvVumv0kmfM68/alwu7HOWH6H6Y7V+v/APwTX8c3vif4U3+n6jqFxdPps0fkwSMCkMDJkKMANjdnrnr+FdkfdZ5c481z7APWilZT1Oc470lbnMI1NpWpKAH59qM80UUAO4r5U/b60l9Q8G6JPDcRWxtrvdJNIAdqEYP/AOr6mvqqvz9/b+8dahqHxG03w6G+zaHpdqt3IRybidyQF298KvT8O9c9Z2pu504dN1UfNKyQaWrf2ev2mboqvCS7sT0QbT7njsOM9Kk07+19d1/T9GtxG1xcXKwzQWqfKjHjEjMMuQM8L8ox3ya7zwb4dlsrZLiV2uPEV/iO1tfM2rAXwFDNxg4wW24ODjPPHqv7Pfwz0SPx/bmNRe3VjueW7Zidzt94joEUg4CqBgY6dK+enU0sfWUoa81j2f4b/Be08O2EPmQAybQC0nLe9er2GhwWqhdgJHsK0FRdg+gx+VS5AXOeamnSUdZBUrSm7R2GNbqq8Vn3EKtn5cH1rSaYYPH61QmlG481VTla0Jhe+5S8ox/dH496ZLbhuWGc1Z37qGbIwBk1jZM6Ytx6mbJaovGM1XMKjoAK0Jvu+9UJM84/lXO0rnVG5FIuB2aq0ihQSAAadJPtzk1SmuAzYHJ71F0dKWhHLjOehqrcNuY88VPM2V3AZH1qjMzFjgfrTuWkzO1bTYb6BlkXdlSNp5HII6V+Yn7Rnw9k8DePbpLJGji/18PHzL0B2n1r9RZFDKQTgkYz6V8fftf+Ghqdml2u3zIWOXA5/P8ApXbhKns6muzPPxtL2lF90fIdq9nr8JuJE23yDa6qmA+MDJ/Nd3+9n1x9df8ABPf4lS+EPi9baW0sf2DWYvss7SNsMZGDER2PIKgcdV55r5KgsZbeOS7hDO6j94YxnaP72PXGeO4Eg+nS/C7XBpviyzvnBLpJFIrWxzjay5A9CNoI/wB0V793F3R8hKN1Zn70Fic5GDSVg+BdeXxN4O0fVELEXVrHKC3U5UEE1vV2J3VzzmrOw1qSnEZpuMcUyR9Kp7UlKKAFxnNfB37bHh8y/FfTbvZmP7IJRtGPmDd/pX3j+NfHf/BQCZdD0vStUU7ZZYZrZXx0bbkfzrjxUeanY7cHLlrXPl/RfHEMMl09lKTcM5tLdtu75sAyyL/tKpUZ4ALkkjt9OfstaZDZ6MZo5FkLylt4beZM85Zv4uvUcHqOMV8PfD/SJr3T4GvJzbWwhaEZU/N83mOWPddz8KOpbHcV9/fs+28NrpQEMbraxsAjTH94xPc4GBz6cCvnKujSPr6WqbPclb5fQVG0vfOKiuJTGCc1QWVpG68VUp62M407q5f8wsTiomiJ5NWLePIzVr7OSOlOKciXJRMwQmjytjE96vSQ7B1xVVn+YjFJxaGpc2pSnjxn5qpyW7Nk4rV2q8hDUrRxqvNYOJvGfQ5m4tzySOazprc8kfLXRXjJyFGazrlQqj5Tj1rPlOtSa3MKbeEIzgVRkmK9cmtm6tfMO4ZXPqDWZdWT/N/+qlys6YyTW4y1ZZNw3EivBP2hdL+32ckKBTE52uCO/TP1r3K3VoNwAOT3zXJ/EDwe/iKxm8rHmsuVGe+aIyaaCUVJNH53Xeh3mi39yiKHwdssOPvRtkBh9cY7/MB1zxi2Wm/2RrEV5BuWKRlkV1HYnLKR26njqMdTXpvxBtzo/iZ7a7TbcW7eW3YtG5G5c/XkehFYWsWsTXMLRLi3kxPwcLnKhsD67uPevoadRyWp8liKSjKx+vH7Ns4uPgf4QcS+dGbCIBu4wuCv4EY/CvS/5182fsD6zc6l8CEt54ZFW1vp4oXY5DIQG49OXNfSbfeNepD4Uz5+ovfaCmU4mm1oZD6M+1IOlLSAXivkL/gohEb7wv4WsCAUnuZSfooRj/UV9ejFfLH/AAUG8OXt18MNI8Q2UJl/sW/D3BX+CGQbSfpnA/GsKusGdGH0qo+HbHUrfS9WsrBUWRLdx5cZJ2nnKEjPY5b6/hj7p+DMkjaLbuE8oNghFHAB5xX5vaxrkFr40fcQiRp98nGeFyAfxIB9q/Sr4WeKvDvh/wCFmja1q2rafpNrNAjtc393HCm7GSNzMBnrxnNfNVaUuZM+wp1oRg7s9OmDTNtx+Zq1a6fwM4GemeleA+Lv26vgz4Q3+X4kfXLsZ2QaTayTbj7OQqY991fOnjr/AIKWXF/ftB4b0DUDnmONpFWRvqqBzXQsLO/MkcksXSStzH6MRqkan+mD/KobrUbeJMlwOcZzgfia/J/Vv+Ci3xPaRkj0m2t1XolyX+X/AL5K/rVJ/wBsT43eL41NudOSBzwqJgP2wQzk/wAq6fYT5f8AgoxjiKfN1+5n6qy65C7MBJnHdecfX0qp/ayt3H51+ZOi/tB/Gvw/5k9z4aj1CD72IJBlB3x8zfqDXWaf/wAFBILPdbeIvDGq6ZLHjzPLZZGX/aYPsIB9s1wyw9feKv8ANHpQr4ZfxHb1TP0GGtRRKW3cZxjvWNrHja0gjd/OwF654r4yuP8AgoN4Fks8RnV5JgP9WtmAc+md+K8b+Jv7Xmu+JrOG30PS5I1up/Li89t0rHjgKvf5h3rKGGxNZ2tZIqWKwdBX5rv7z741P48eG9Hhnku9Tt4Fj4/eOAWOMnGeuARXm2vftseCdKhmeO9+0hFyPLZGOfTG6viW3+DvjHxSfO8U6+unyOpmNrGSzKCBkFjkLxgYwelYGr/D/wAJeGJlS7uZtRIHzTxKxUckfw49K76WHpfalc5q2Krx+GFvU+otW/4KERyeaNNsogf4ZJWLY/ACqnhz9uV2kSbUp0PzfNa/Z3kRhnqDgbePrXnHhv4KeGn0CDWb7w5cRaRMAI9QvJ96bj0G1ZMjODywAGB610tp8AfB+tIRZWKy7h+7ltZ5I9x9MoQM8dD+ZrV0sL9pM541sY3eLR79p/7XvwzvrVHm177JO2MxPZ3HB+ojIrodH+P3w+8R3SWmneJ7W7upThIVilV2PJ4DIM+lfC3xE+BeseBdHbXY4bmTRFlWKYSD57ctwpPPQtgZ9+9bP7N/wv1zxt4qt9X06ONNO0u5jM1xI4UFuojXIPJx+uat4HDOn7XndjFZnjlX9hyK52f7WSwQeObTVYLa4NptjEk32WRY1fcR8xIHqK8k1q/HnXNkj4/eo64IOAxb7oz0Br6F/bN17WdO0q20Z9P05LbUMv50jySSJtdeByBkA+navl/wHpV3418dGzikUzMxjWNR/ebgk46Yb+dOPs4UueDukTL22IxCpzVmz9Wf2BYru1+CL2126GRdRmYKHUlFITGcGvpXtn8elfNPwDVfB/jqx8O6eY49I/s8YjjQASOoUlz3JNfS38I9cV04OusRTdujOPMsHPA1VGbvzK42iiiu48nYUN2p1Mpw5qAFz7Vj+MfDum+MPC+p6Hq8Yl06/gaCdP8AZP8AXrWxXC/GbVtQ8P8AgW71fTHxc2DpOYyOHjB+ZT9RWFer7GlKdttTrwtH6xXjRT1bS+bPx8+IfheD4S/tDx+HvENu+qWVhcEL9lAf7TCwJiZdxwT93IzwcjtXuvxs8K3Xxu+DgsPBGiXn9o6PqG+WCaFIQybCCEKsQSC3Q4r0j9ozT9A8aeErbxJpvh6KfVJo/PW6mXJt0Qgy7fz/AFrS/Yx162vpPE2kqxZW2zbcDqDgn37c4rxqWOdSKlTR9LWytU5ezqPS35H5seFfDNz4k8bWnhy7Emn3Mly0N3uT54Am4yEDpuUI3PsK+0dA8E+CvA2kwwW1rFDt+WWRolJkIGSzNgFj9elYHxu+H9t8Of29tBmRYrfTvFNo1wmQPLWZreSBuPUuqnGP+WlU/jdofibVNRTRdIs3kMwLSrCGKsMcljt/1Y7mrxlapWlBRla5nlVCjh4VJON2mc98RPid4NsFmMdnFqEy/KCiEKMDoWP9M1yNv8SodUs4zYWkNrmPf/o1mHbjPVj1wBWvov7MGqC0urrW9Vs5mMGyOOL5hHk4wm4gAgd6ydT+FEfhu0FvDfXSlV2NcLIBxyPmIzjPSqo/V4rWVx15Y2o/djZFbwb8V7my1pZdSMOqacBuNvMWtyRjOcocmuj+Nq6T8QPhvJ4htNMtbGXTxHPCLcvIqozKrJuf5mGWJ56HOOK4GPwjaX1xDZPf3U/lqsapGocrg9ARjrn1r2z4weFofAH7L+pXDxtFPem3s7aORtzHMgY5/wCAox/CtHKnGUZU97mXJVlSkqvY+bPCPwTvvGGiNrUFyI45HdLe1VTLK6ocM7DPAzx6nnit/wCDdnFD8dvCmlanDsNtPIuyRMfvvLcxtjtyF/P2r71/YF/Z/t/C/wAFtP8AGGtwGXUtbzcWySc+TbZOxgD3bls+jD0rxv8Ab4+FR+H/AIp8O/Fzw9biB7W7iTUUiGAHV1aKQ46AnKE+prWWJqe0nSls9jGOCoqlSr0170d/1M/4maLcw3UQScWtlOjMzNNtMhK7sAnr0NeA+O5bS/s7L7J9oN4LpopkwygLyBt5wee9fYGt6PafEnwrpesaW/nabdQrdQSIgfbuHcHuDwQPQ15lP8MdS0S4Mv8AZ/2xVfPnWybu+c4J4/CvPo1lh7xfQ9nEYdYtKV7XPF/Aeh395q1qbnTtQt54XWM3tqWBEI656fNkAenHQ5zXtnh+PXPCdwXksr6W1kbba6x5IDng4SaPnIJ7jtj6V2nh/wARWulwtHPbpE7HJzbsnJ/PP51674R8T6Y+kPDLGd5bck5RuPbJXAx7GtKmOVTRqxz0srnRfMm2cP8AELRL68/ZQ8X31/Jp6XH9ntNJDHL+8VlAZRtx2YA/4Un7Cvh+2X4OrfmIGW71K6lUv3QYj6f8A49KsftPara6X+z94xula3P2m2W3WSMjlpJFUdOvU/8AfJrsP2V9Bk8K/BPwdaTR7JmsRcyKRgqZmaXB9wHA/CsqlZfV7W0uXCjL63zdVH8Txz9uiA/bPDYZSUXzAGI6g4H9K6n9iX4a6bB4avPFUttDLdS3kiQuy5eMR8YU46Ybpiov24NPWbRdFuiuPIcr5n1Fdn+zP4ys9P8ADtl4ehtIo7GOBbg3D5VpJZDub9MD8K53UVOiot7ndToyqYlzir2R6b4ZjOnfHjQYkJCvDMCMY6819OBu+Md8V4L4e0H+0PjPouqxkvbJp0hLjnD5HP8A49XvI+6PpXoZTTcIzb/m/wAjyeIqsatSkluor9QNFFBr3T5IKUfWko/GkIfWZ4m0OLxJ4e1LTJuYrqBom9sjg/hxWhzSqev+f89qidNVYSpy2en+ZpCbptSjo07/AHHzR8P/AIbwa94I1bw3qODPZtPZb+jKCP8ADH514F+ybpM3gf4+eK/C08rNJaRTW+GPXEgK/wDjq/rX174hsD4UvvFOoIzRRXSxXGV/v7CrH2+6K+UvAKT6P8fIvF867rHXJjafat2P34VsjpzkEflXxkXGg/YSXvI/Sa6njr42L0dvxV2WP+Chfgy+HhHwv8SdFjY6r4I1OO+YxkhzbM6biMdldIyfYmvXdB1Pw94r8L6bqvh+1bVINXt471EtioJVlBBkkJ4I+7yc8YHFekeIdJtta0u5064tYr631CNrWSCUZSSNgQ6kH/ZJH418yeG/AfxJ/ZDlu9N8P6Fc/FH4TvKbiGzsXH9raSSPmURkgTJksQB659q6px9vTdNOzWx5MKn1aoqjWktzX8YaDrV6rpH9j01VORHbCS9kP1LFAp/OvJpPgfqfiu/8y+ae4jVvma4OM/8AAVx+ua9V1f8AbG+GscCx6hD4j0G6AANrq3h+8jkQ+hwh5/Sucm/ay8LXy7PDXh/xd4mm6Kml6BOFJ92kCgDPeuT2NaL91HqxxVCUFdm74N/Z98OeE/LuTZxtcZGX6ZYn0PHcV8+/tSaqPjp8Z/BHwc8Ov59rb6gi6pNb/cEz4DICOC0cO89eN1ej654o+KHj6B0ultfhD4elGyS7nnW91mZO6xIn7uInnlzkZzzXpf7MHwR0HSPFza9pemyWujaTbfZdNkujvnnmkJNxcSP/AByHIy3bkCumjP2Tu3eT6djkrw9rTaa9zv3Pp630u30Pw1a6VZIIbKzhSCBEwFWNFAQAdhgCvHvip4RsfiF4Q1vw7qUIls9RgeCRT6kHBHoQ2GHuK9pvBthYEj5gcgdBXnerRCOaQAZDdzWlRuMk1uYYeMZQcWj82vgz8TNU/Zu8Rah4H8dQXUnhu2uCYNSjjLmyJP3yB0jbOT6EnrX13p91onizSUv9H1C2vbKUBkuLeQOhHrlT/Op/iV8J9N8aTrPc6ewukyqXcIG7HoexGexzXz/e/sy6Rpuqu+m3uoeHb5zlpNKuntC59dqnb+QFc9apSqPma5WehhqdSn7sfeX4o9j1bwmSUdG388Fuf5Zq/oLWnhuCS51O8hsLNc77i8lWKMAdyzEDFeW2f7P2t3keyb4neNmg4zH/AGsM49M7M12PhT9kz4f218l5rNlf+K7ociXX7+S6GfdCQh/FSKwvSb1lc6p+2irKFvmcX4ztYv2rvEmneHvDEM0nw90y7W61zX/LZIb2ROEt7fODIRlssOB1Gcc/UGnn7Lti8oRNGAoC/d49Pb0rS0zTrXTbWK2tLaK1tYVCxQxIEjQeigYx+H/1qj1CHcrFfvRjI7VpVl7S0VokcVODp3k92eA/tQW1z4o1LwV4btoiTq2qLC7H04J/DG45/wBmtz4q6Db/AA/0fStS05vKLW8UGwYByqhc49wBXbLY2+qfEC1uLlI3NlYNLE8v8LO4Tj3wG5+vrWta+G4PGniS6j13S1m0y0JWy84Z6fxYrOp+8j7M7sHJYaftt+h0/wCzLeT6to8F1cqwlWKQJu643KK954ycdM15t8KNPW3e+mhiENtGqxRoPUNz/KvR93Ue9fU5fT9nQ5WfEZzWVbFuXQf+NI31oPTOaZuzxXpHgoduoByM0w/WnLwAOtADqKKKAOO+KWgyeIPDF5bwfLJJHt+vOR/n3rwbwv8ACy81DwHcaFrMZ0+eO8+1adcgDckinIYfio719R3kK3FtJG3IYflXH61byrEHWJZnRDsDdc9K+azDCx9t7fyPscrzCSw7wT2ve5Q019yxTTEM6wqCV9SOa1ZHTb8p6DjPauKuNbfQ/D6XNyBEwdUk3HpyBn9a2LjUg0KzbsKy5BFeeqttTs9i5NXW5i+Lrf7Rat+9aN15XDcdfSvn34jePX8M2sqC78yQfKu5snPtXoXxP8cJpdjKRJhyMDn9a+WrFbr4mePIrdR5kEbhmLfdbmvKrS9pOyR9Jh6KoUryZ6L8EvDa+MvH2nXviZZri2kYlPNVti4BIBPvj9a+0RqOk6XbrDBJFDHHlQiEDAIwcD8K8n0Oxh8M6dFEAuI1GQo4xxz19q8L+KXgUa34kW/03xf4l0VcF3tbK+YI7AjOBkADocEHrXZRk6CskjzsRTji53k3ZdD611jxpYqpCyA7Rz9PWuNv/FFm2OshY8Fecn0HqfavBrrxdcWvht9Nl1abUbu1lCiWRFExXbyH24Bwc84/xrOv/Fel6n4VW11S6uEWRPLmtYiUeYnnaSCDtPPHSm605y1RrTwtOEL3PbE+I/hubUf7OTVbN7/Pz2q3CGRfqucg/Wud8S6JF4kvpWtwGt0HEikZBx2P1rwDS9E8KaLNFfaTocNrNEcpMkLKcemUxzz717toHiiG+gSMvswNuFGDkDOMH2qpw5io2p7HEt4juPBuqJZ6gcwyf6qVu/sa9V8O+IIL6BGDAnH0rlfHHhmw8XaXLbyrv+XKzKfut65rzzwreav4SvEtrtvtVtnbHMp4bnp9a4eSUHdHbGaqxs9z6QS9V1xurP1S+S3jQlvlLbTg/jWPpupC4tfNzgDr2Iql4guo5IFTcc+YrDB7Hit+dnDKnZ2L+ikalfSbAY2nt+JMdVV+P/QxXd2M6xzCM/NEF+8p7dq4XwbpV/faraRaXZG6uIYpC0RYK2z5B1PXkrXtXh3wHOZI59SRbZFwy2+4Fm9M44/CvRw9KVZp20PPxGJpUIuMtzpPB2mDT9HQHgysZSPr0/TFbm3ao7n1pqgKBgBQOMCnM26vracfZxsfn1SXtajm+onNJ70tJxWhkLxRmjijigBc7qVflGM03NGaAA/erE1yaOwQTSjbEDy3FbdGflK9j9axq0/axstDoo1nRmm1dHz/APEDHi7w/dw2TuFll8tce3X/ABzU2vX39j+F4Cxb92BFlj+A/lXb/Ea2EM6uvyBo+OOrHj+QrzfxhZvq3hO7tl/1incoB7DkGviMXTdOpODep+gYOsq9GE+iZ4h8XdL1HW/ENtoVo+69uBht3CxDuT7VtfDvwDp/gtlTer3K4Mkh7sVJBAz04rofiNpbWeo3euwfLLJaowbd2HzY6epr55174zw+GtYil1KZ49xD+Y52oy4zjPsT6dBiuagt7K569WV4pX0Pp6S4TXLdUjLkwyFJCnO7jBHXjnJrGuvhje3Vo7QlvOZWi3buCrDkc9D79q+QfFn7c17Pq/8AYvgbTo3lZ9hvJVyGPTKgde9ex+DPC3x38eSaUsniGO3TULQXqL9icqYzjgMGHzc+lds4zjbnjuc9CMJ3cZqy+RQ8X/Ar4gSeYNNvI7eZgUVpmK/NyBlgpz19a50fAnx2s4fUbiOZ8klomOc+gz6c8969x0v4WfGKLTb25h13S9QFvL5XlhXUtjqMMvJHGeeuaPDPgH4q+Mp7iG5urPR4oXCO+Scv3HTtx370lzraJp7PD6y9qrddTyzS/hZrdzCEvTcW5hZEgRkwQASSc55Jz1rt9L8M6npdrslgAi8xmLxsdynseB34rWt/hr8R5bHUrj/hJkt0sWYSrDAS4wTuALHGcAmsD4neDPiboy6dH4e8QT3NzPHHK638CONrsEBbAGOWB5PTPpW0eduzRElQim4zWhDqOp6ppttsll+zRsSrxbWyF/hOcc56frTdH1yDxFHJZi2wzLsZZeiSKM7lP5fnXx1qv7TnxM1zWLrQDb2l/cxytButrcq25WKseCRjjNeyfDa81svbG4l8y4kAXDeueD/L8qWIpOnG7OXD16daTUEfVGk5XQRK+cPGvU8njrWNqt5HI0yEYAWMD1yDn+tbc0q22hWsRQNIUG7avQ9zj65rAhjVrld4GMl23Dt0H8jXmo7merfAuR/+E3jjIUhraUhs/Nj5f8/hX0Pj3x6LgACvnn4AsLzx3qBKZa3sfkYDhQWUE/mCPwr6H9cjHNfZ5emqFz87za0sTcOPajijijivUPIDijijijigQcUcUcUcUAHFHFHFHFACY96OKXijigDmfH9ks+iGfbu8htxx/d7/AJf1ryKzd5JpUk5/hAboRXvl9aR39pLbSj93MpQ49x/+qvAdSt59B1Sa0mQrsODu7j1zXzea0bNVEj6zJ614uk2Z/iyxGo6DDby/P5R2fL3r56+LH7MMXxOisrGYfZCJf3VwOsZOSPqOa+nlX7XC4wBlc4Az+NWbXybiBAT++j5A78V4FFOFRSi7H0zneDjJXPyu1z9mjx9+zf8AEXSdfn0c+INN0+6jcvapu34bIyO2SB3479a/UHwN8QLmS10STTPCurSq4lsRCsaI0CJ8zONzDKgjb1HzZHau1u9BtNe02NbhFkyMEtz7Eflx7dqzD4EsNIszGk0qRRqfKjWdwsYPYDOMe1e/KtUkuaSPEeGoTfKm15eZa074qabb2KRX0E2mzs7vHBPGzsykA7spuUHHbPHrXLf8NK+BbVdRT7e0D2tzL5sRt3BJyGJAx1Oc4rA1PS9OjYr9jS45wC64yMgHJ79ayT4Ts7i3At7K1sdoZjsUHcT3/I/pWH16eyR6VPI6DSc6js9yDxL+1RaW39txadpi6sJG8yzkt3dUlDqAfM+Q7WGT69a8/wDF3xb8afENpNN0XTm8NwSC3Vr53ElxjcS8YGNuPQ+nbsPSbXwPYM3lzBWjXkMo2g/gOtbun+HdP0VglusYBXcWcDIPqKn21WerVjR4HA4dJxvJ+Z4V4T/Z30jwHpErxW6Sare5zNwXAYctn1PU/WtzS/BcNvPbmKJQLUrEp6ZHc59c5r03UJ1aUrHEXZRgZ+XA9axg3mXnlBVWLoxUfxAj/GvOrN1Hqzth7kdFZdEJqdwFYRA/vQNi8dqxMfZ2Z33IzfLknI7DH6k1tSwrJI8mBv4yxOQOO1Yltay3VxJCgYrvZn38g4Bxg/lWUI3kZzlyxPZf2Z9JcLr2qzlWeV47ZSPRVLN+rZr3JfujIwcc14H4E+KHh/4baloPhvVCNPHiFpJLaeQ4TzlVSyE/7pHPt0r3tWDKMHcMfe7H3r7XCW9irH53jruu2x3FHFJxS8V3HmhxRxRxRxQAcUcVFzSc0ATcUcU1T8vvS5HpQAvFHFJxS8UAFch8QvBv/CRaeZbVV+3xjI3cbx6V19I3TPXvWNSmqkXCRvSqyoyVSO54Pp8TRzFJlaMJwy4wQRwRUlvaiG9YxlQGGck5x9a7rxxosUlxFcJHsdgc7O59642O8EdwA0SjjADDGff3r5Sth1Tnyn2lDFOrDmL9rePZxMmWOfunHAPpXKeJ/G2oW8cyrErrGP4fvdPTvXdeXHd2gKjafz5rB1PwXBqCkSq2SMZU1k+dLQ6qcqad5I+f9e+KlzZxmSfaGHzlRz8oI4/SuS/4WzqDTRTQ7ntnOMc5HUgAd+te7618GtLkjZfIjVm7lc/pmubi+C0Wl3HmQ3cbDqIliwVPtyamF92jvdaD2OS0HxVrV9JDunEcrkKNoJwPWvS4bqSOEbnM0jLje/Wr2m+EIIY13JhgOWZQGyK0G0yCIkMdyjrQ+awuaEtjl2yryTuGUkBdzHI+tVbdliuUZyu1iSMHgknrjt0rV17VIbe1dcRrE42gsSOenp64/OuO03VLVfMWQbH3FN2CAzKTkN6+3TIxUxh1ZEql9EdH9lVlkEr4QcDjGcd6uaTbxqwVCcKdw/POKyYZn1Zt+3y4cYUev+FdHp8It40CLketPmS2J5XLc+e/+ChNrcw/B3RvEdk5jutD1aOYMv8ACrqU/mV/Kvr/APZT+LUfxm+CXhjX92Zbi2Ec3P3ZU+VwfxBr5+/at0dfEXwB8Y2ZQH/QXmTdz80ZDjH4iq3/AASlup3/AGfdUikZjFb61PHGWPHKoxx+JP519Jl8+anY+Rzan7OpzH3UGGBnrilyK4zWviZZ+F9YgsdVja3S5H+j3H8D46j2wOv4V0un6taapD5lrKsiex5/KvXlFxV2fNxqRk+VPUvcUvFQ8ilqXoaBQOuaKKAD+LNH8WaKKQxwftin/hUaqW+7UqwnHNMQ38KQ5ZelPZNvTk0iq7MN3y1XKTcxfElq0mm+ZjmN85HpivKfEmmzxrJeWhD3KEMFkOAVxyK92vbZZ7SWI8h02/jXk2oRE5DDaV44rwcwgoy5j6PK580XFnJaR46jk2rFuBVtsiZJG70HFa1141too5HMygr1yfauB8deEpLhpLnT38m7UZXCjFfPPiTxvrPgqec3Ebkxndh1LKxPU8V4d5PRH0sKdN+8z6Y1b4hWbsivOIQ4yGfp7Vnr4+t4JJN0yMm0lXIBHbgc9a+VNc+INrq0MbW98iTbQ22SUbR6jBxWVF8QbGym+e93PgMjGUFWY8cc9sUoqWuh0/u0lqfW914+iX/VOJy3ZW5HsfSsXWfHsk0PlwoXWP55GcjansD+HPpXzhH8W4Z3Jt2kurjaXeK3jZ88nnIGO3rWnp154n8ZR+Tb/wDEp05nyzsoZnXBDKRnjOfU9BT5GtZC5qbdorU73xZ47lvLz7DYvJf+ZMiLGOQrAnuOmCM1vaDoz7Y5bzmYgFogcqvcDPcj1rG8J+EbfQF3K7ySlQvmMeeBgE+9dlbyovC/LWM6j+FG9OlbVnQ6fGnGOT1J6CteGVhwpworEtWyi5q9HMIUPOCepPT2rONzSSSOE/aQ1uHSfg94qlkYbTZOmD33ALgfjXoH7Bnwwk+GH7NPhq1uIzHfanGdUnVuoMxDKCPUJtrybxjo7fGr4o+HfhzAjT6ZDKmra8y/wW0bDEefVzwB9T2xX2vaQxWcEcMSLHDGoVUj4UADGB7V9VlNNxg5PqfC55XUpqmt0Yfj/wAE2Xjzw7caTehkV8vDOhxJBKPuOp7EH8xxXhvwJ8eatp/irVPBuvMP7W0qTZ5g486MH5X9sjHHOPWvpKXEisoPavmLxTajS/2qLO4jGw3dkWlxxkAE/wA1/WvqKT5ouDPiay5ZRqRZ9VW14wQFiCDVwMGGQciubt7rzLRGzglQf0og1ma3fAII9643BnoRnfc6WiinQjdJg9KzNwVC/QVKtvt+9+VTFRH93ijcWGT1qrE3GrhRwMUbz0pKUda0sMDwuaiRmkk4pbriMYpLP7pPekZNi6jcfZ7WbBOVjJBHUHntXjui6sniHR4L1DzJkMCehBIP8q9S1SZhY6g+fmWBiPzFfN/wJ1S4vNH8UW0r74rTWJY4eOVVo0cj82NeLmS91H0OU/Ez0C4sftUe4DkD1xXlHjnwXb6ksgkhwZCAzIMlh717N91yB0ya57XLVGWZ8sCoBAB4r5youx9VRlbRnwf8TvAttputfZbKIeWNxAQcnnnP41z2k+EUhY3EtrHOgGdpQM2enGRX054k0S01LVpmmj+bJ5XiucuPD9jC+Ei2lDww61Ea84qx3/V4Sd2cp4V+Hti1vudB5TIqtHtXb09Me/bFeh2OlQ2Fv5cUYWPoMU7SYk8gIFCrnoK044xI53c1jKcpI6Y0ow2KkZ8uTA61fs8uecYqlIMNnvUlmxI61kWdLDMEKr1P1rn/AB544Xwvp6rawyX2tXTCCx0+EbpJ5m4UAfXnPTirN1dPa25dcEhSRuGe1L+yNodp4yuNd8b6wrXuuW97Jpts0hzHbQhQSI1/hLHqc5+lenhKKrVFFnjY/FPDUnJHpv7OPwdf4X+H7rUNZlW78W6zKLvUrlTkK2MJEp9EBx9c8V66fTp9KgibdGSetSda+5p040koR6H5dWrSrzdaW7HxNtYknjOPxr528dTRXP7SkYVgfsOgq0hHZpJiqj24BNfQTLu9u3Hvtr448O6zda18dPibe3Um+db1bNccBYogVRQK7KK1Zw1noj6p0e9NxboQ2VwK1kjDYHeuI+G15LdaRJ5hztwBXeQj5Qe9YNanTFn/2Q==",
    },
    auth: {
      type: String,
      default: "user",
    },
    plan: {
      type: String,
      default: "Free",
    },
    packageTime: {
      type: String,
      default: "Monthly",
    },

    apiUseTextToImage: { type: Number, default: 0 },
    apiUseImagination: { type: Number, default: 0 },
    apiUseImageCaption: { type: Number, default: 0 },
    apiUseFreeLimit: { type: Number, default: 0 },
    apiUseChatImageLimit: { type: Number, default: 0 },
    apiUseImageAudioLimit: { type: Number, default: 0 },
    apiUseScratchToCodeLimit: { type: Number, default: 0 },
    apiUseGrammarChekiangLimit: { type: Number, default: 0 },
    apiUseTextToParaphraserLimit: { type: Number, default: 0 },
    apiUseAiChatAssistantLimit: { type: Number, default: 0 },
    apiUseAiTemplateLimit: { type: Number, default: 0 },
    apiUseEditAudioLimit: { type: Number, default: 0 },
    apiUseVideoToTextLimit: { type: Number, default: 0 },
    apiUseAiVisionLimit: { type: Number, default: 0 },
    apiUseWebScriptingLimit: { type: Number, default: 0 },
    apiUseYouTubeAnalyserLimit: { type: Number, default: 0 },
    apiUseAiRewriterLimit: { type: Number, default: 0 },
    apiUseSpeechToTextLimit: { type: Number, default: 0 },
    apiUseAiVoiceoverLimit: { type: Number, default: 0 },
    apiUseAiCodeGenerateLimit: { type: Number, default: 0 },
    selectedVIPAssistant: [
      {
        value: { type: String, default: "nin" },
        assistantIcon: { type: String, default: "nin" },
        assistantName: { type: String, default: "nin" },
        assistantCategory: { type: String },
      },
    ],
    selectedPremiumAssistant: [
      {
        value: { type: String, default: "nin" },
        assistantIcon: { type: String, default: "nin" },
        assistantName: { type: String, default: "nin" },
        assistantCategory: { type: String },
      },
    ],
    password: {
      type: String,
    },
    refId: {
      type: String,
    },
    Date: {
      type: Date,
      default: Date.now(),
    },
  },
  { versionKey: false }
);

const userModel = mongoose.model("author", authData);
module.exports = userModel;
