const mongoose = require("mongoose");
const imageChatDataSchema = mongoose.Schema(
  {
    title: { type: String },
    massage: { type: String },
    assistantIcon: { type: String },
    assistantName: { type: String },
    title: { type: String },
    packageType: { type: String },
    category: { type: String },
    promptDescription: { type: String },
    brandIcon: { type: String },
    last_chat: [
      {
        message: { type: String },
        sender: { type: String, default: "chatGpt" },
        sendTime: { type: Date, default: Date.now() },
        email: { type: String },
        inputValue: { type: String },
      },
    ],
    active: { type: String, default: false },
    favorite: { type: String, default: "dislike" },
    createDate: { type: Date, default: Date.now() },
  },
  { versionKey: false }
);

// Pre-save hook to ensure default values for `last_chat` field
imageChatDataSchema.pre("save", function (next) {
  if (!this.last_chat || this.last_chat.length === 0) {
    this.last_chat.push({
      message: "Hello welcome to Rapid AI",
      sender: "chatGpt",
      sendTime: new Date(),
    });
  }
  next();
});

const imageChatModel = mongoose.model("ImageChatData", imageChatDataSchema);
module.exports = imageChatModel;
