const mongoose = require("mongoose");
const packageSchema = new mongoose.Schema(
  {
    title: { type: String, required: true },
    packageType: { type: String, required: true },
    packageDuration: { type: String, required: true },
    packageCurrency: { type: String, required: true },
    price: { type: Number, required: true },
    textToImage: { type: Number },
    imagination: { type: Number },
    imageCaption: { type: Number },
    freeLimit: { type: Number },
    chatImageLimit: { type: Number },
    imageAudioLimit: { type: Number },
    scratchToCodeLimit: { type: Number },
    grammarChekiangLimit: { type: Number },
    textToParaphraserLimit: { type: Number },
    aiChatAssistantLimit: { type: Number },
    aiTemplateLimit: { type: Number },
    editAudioLimit: { type: Number },
    videoToTextLimit: { type: Number },
    aiVisionLimit: { type: Number },
    webScriptingLimit: { type: Number },
    youTubeAnalyserLimit: { type: Number },
    aiRewriterLimit: { type: Number },
    speechToTextLimit: { type: Number },
    aiVoiceoverLimit: { type: Number },
    aiCodeGenerateLimit: { type: Number },
    selectedVIP: [
      {
        value: { type: String },
        assistantIcon: { type: String },
        assistantName: { type: String },
        assistantCategory: { type: String },
      },
    ],
    selectedPremium: [
      {
        value: { type: String },
        assistantIcon: { type: String },
        assistantName: { type: String },
        assistantCategory: { type: String },
      },
    ],
    createDate: { type: Date, default: Date.now() },
    active: { type: String, default: "false" },
  },
  { versionKey: false }
);

const PackageModel = mongoose.model("Package", packageSchema);
module.exports = PackageModel;
