const fs = require("fs");
const path = require("path");
const ytdl = require("ytdl-core");
const UPLOAD_audio = "./AllFile/youtubeAudios";
module.exports = async (req, res, next) => {
  try {
    const videoURL = req.body.fileData;
    if (!videoURL) {
      return res
        .status(400)
        .json({ success: false, error: "No video URL provided." });
    }
    const audioStream = ytdl(videoURL, { filter: "audioonly" });
    const audioFilePath = path.join(UPLOAD_audio, `${Date.now()}_audio.mp3`);
    const audioFileWriteStream = fs.createWriteStream(audioFilePath);
    audioStream.pipe(audioFileWriteStream);
    await Promise.all([
      new Promise((resolve, reject) => {
        audioFileWriteStream.on("finish", resolve);
        audioFileWriteStream.on("error", reject);
      }),
    ]);
    next();
  } catch (error) {
    console.error("Error processing request:", error);
    return res
      .status(500)
      .json({
        success: false,
        error: "An error occurred while processing the request",
      });
  }
};
