const express = require("express");
const router = express.Router();
const path = require("path");
const fs = require("fs");
const blogImageUpload = require("../Middleware/BlogImageUp");
const visionImageUpload = require("../Middleware/VisionImageUp");
const imageToAudioFileUpload = require("../Middleware/ImageToAudio");
const imaginationImageFileUpload = require("../Middleware/ImaginationFileUpload");
const imageCaptionFileUpload = require("../Middleware/CaptionImageUpload");
const scratchImageUpload = require("../Middleware/ScratchImageUpload");
const uploadAudio = require("../Middleware/AudioFileUp");
const EditAudioUP = require("../Middleware/EditAudioUP");
const videoToText = require("../Middleware/VideoToText");
const emailVerify = require("../Middleware/TokenVerify");
const deCodeEmail = require("../Middleware/DeCodeEmail");
const downloadYouTubeVideo = require("../Middleware/DownloadYouTubeVideo");
const googleVerify = require("../Middleware/GoogleToken");
const {
  visionImage,
  visionCountUserDashboard,
  allVisionTableData,
  deleteVisionData,
} = require("../Controller/VisionController");
const {
  videoToTextController,
} = require("../Controller/videoToTextController");
const {
  imageToAudioCreate,
  imageToAudioTableData,
  deleteImageAudioReq,
} = require("../Controller/ImageToAudioController");
const {
  authRegistration,
  authLogin,
  authUpdate,
  verifyEmail,
  recoverVerifyOTP,
  getAllUserList,
  recoverRestPassword,
  getUserDetails,
  affiliateSubscription,
  totalLimit,
  deleteAccount,
  totalPrice,
  deleteUser,
  googleLogin,
  freeUserCountAdmin,
  paidUserCountAdmin,
  totalPaidUserList,
  allConsumeDataAdmin,
  spendMonyCountForMarketingAdmin,
} = require("../Controller/AuthController");
const {
  userChatImage,
  getAllImageChatAssistantData,
  allImageAssistantTableData,
  deleteChatImageDocument,
  createChatImageAgent,
  deleteChatImageAgent,
  updateChatImageAgent,
} = require("../Controller/ChatAiController");
const {
  ArticleGenerate,
  articleCountUserDashboard,
  allArticleTableData,
  deleteArticleDocument,
} = require("../Controller/ArticleGenerate");
const {
  ImageController,
  AiImageList,
  AiImageListHomepage,
  AllImageTableData,
  deleteImage,
  imagCountUserDashboard,
} = require("../Controller/TextToImageController");
const {
  SpeechToText,
  AllFileAudioText,
} = require("../Controller/SpeechToTextController");
const {
  AICodeGenerate,
  AiCodeList,
  deleteCodeDocument,
} = require("../Controller/AICodeGenerate");
const {
  textToAudio,
  AudioTableData,
  deleteAudio,
  textToAudioCountUserDas,
} = require("../Controller/TextToAudioController");
const {
  BlingInformationData,
  orderList,
  sentOrderId,
  updateConformData,
  deleteOrder,
  TotalOrderCount,
  getOrderNotify,
} = require("../Controller/BlingInformationController");
const {
  createPackage,
  createPackageList,
  packageDelete,
  orderPackage,
  showHidePackage,
  createPackageListAdmin,
  editPackageDataGet,
  updatePackage,
} = require("../Controller/packageController");
const {
  SaveAffiliateData,
  getAffiliateData,
} = require("../Controller/AffiliateDataController");
const {
  createBlog,
  readBlogDataAll,
  blogList,
  deleteBlog,
  showHideBlog,
  editBlogData,
  updateBlogData,
} = require("../Controller/BlogController");
const {
  payProduct,
  stripeMethod,
  stripeUserData,
  getStripeAdminAllData,
  createPaypalData,
  createStripeData,
  createOpenAPI,
  getOpenAPIAdmin,
  getPaypalDataAdmin,
  createGoogleClientKey,
  getStripeDataAdmin,
} = require("../Controller/PaymentController");
const { aiReWriter } = require("../Controller/AiReWriterController");
const { contactForm } = require("../Controller/MassageController");
const {
  createTemplate,
  templateListAdmin,
  showHideTemplate,
  updateTemplateData,
  deleteTemplate,
  getAllTemplateUser,
  getSingleTemplateData,
  setFavoriteData,
  getAllFavoriteTemplate,
} = require("../Controller/TemplateController");
const {
  createAssistantAdvanceSetting,
  createAssistant,
  assistantListAdmin,
  showHideAssistant,

  getEditAssistantAdvanceModel,
  updateAssistantData,
  updateAssistantSettingModel,
  deleteAssistant,
  getAllAssistantUser,
  getSingleAssistantData,
  setFavoriteAssistantData,
  getAllFavoriteAssistant,
  chatWithOpenAI,
  allAssistantTableUserData,
  deleteChatDocument,
  updateAssistantPositionInDB,
  vipAssistantListAdmin,
  premiumAssistantListAdmin,
} = require("../Controller/AssistantController");
const { WebScripting } = require("../Controller/WebScriptingController");
const {
  aiYouTubeController,
  youTubeAnalysesCountUserDashboard,
  allYouTubeTableData,
  deleteYouTubeData,
} = require("../Controller/AiYouTubeController");

const { detectContent } = require("../Controller/ContentDetector");
const { PlagiarismChecker } = require("../Controller/PlagiarismChecker");
const { Paraphraser } = require("../Controller/ParaphraserController");
const {
  imageCaptionGenerate,
  captionImageDataList,
  captionImageData,
  deleteCaptionData,
} = require("../Controller/ImageCaptionController");
const {
  ImaginationImage,
  imaginationImageData,
  deleteImaginationImage,
} = require("../Controller/ImaginationImageController");
const {
  editAudioFile,
  allEditAudio,
} = require("../Controller/EditAudioController");
const {
  AIScratchCodeGenerate,
  aiScratchCodeList,
} = require("../Controller/ScratchToCodeController");

const {
  autoCheckTextValue,
  fixErrorTextReq,
} = require("../Controller/GrammarCheckController.js");
const {
  createOrUpdateSmtpInfo,
  getSmtpInfo,
} = require("../Controller/SmtpController");
const {
  createFaqInfo,
  getFaqInfoUser,
  getFaqInfoAdmin,
  showHideFaq,
  deleteFaqData,
  updateFaqAdmin,
} = require("../Controller/FaqController.js");

const {
  socialMediaCreate,
  readSocialMediaAdmin,
  showHideSocialMedia,
  deleteSocialMedia,
  getAllSocialMedia,
  updateSocialMediaAdmin,
} = require("../Controller/SocialMediaController");

router.use(
  "/ImaginationFile",
  express.static(path.join(__dirname, "../AllFile/ImaginationFile"))
);

router.use(
  "/captionImage",
  express.static(path.join(__dirname, "../AllFile/CaptionImages"))
);

router.use(
  "/uploads",
  express.static(path.join(__dirname, "../AllFile/Upload-image"))
);

router.use(
  "/chatImage",
  express.static(path.join(__dirname, "../AllFile/ChatImage"))
);

router.use(
  "/findAudio",
  express.static(path.join(__dirname, "../AllFile/TextToAudioFile"))
);

router.use(
  "/findEditAudio",
  express.static(path.join(__dirname, "../AllFile/EditAudioFile"))
);

router.use(
  "/findImageToAudio",
  express.static(path.join(__dirname, "../AllFile/ImageToAudofileStore"))
);

router.use(
  "/AllFile/Blog_image",
  express.static(path.join(__dirname, "../AllFile/Blog_image"))
);

router.post("/deleteAudio/:id", deleteAudio);
router.post("/textToAudio", deCodeEmail, textToAudio);
router.get("/textToAudioCountUserDas", emailVerify, textToAudioCountUserDas);
router.get(
  "/AudioTableData/:pageNo/:perPage/:searchKeyword",
  emailVerify,
  AudioTableData
);

router.post("/createArticle", deCodeEmail, ArticleGenerate);
router.get(
  "/articleCountUserDashboard",
  emailVerify,
  articleCountUserDashboard
);
router.post("/deleteArticleDocument/:id", deleteArticleDocument);
router.post("/deleteCodeDocument/:id", deleteCodeDocument);
router.post("/deleteVisionData/:id", deleteVisionData);
router.post("/deleteYouTubeData/:id", deleteYouTubeData);
router.post("/deleteChatDocument/:id", deleteChatDocument);
router.post("/deleteChatImageDocument/:id", deleteChatImageDocument);
router.post("/deleteImageAudioReq/:id", deleteImageAudioReq);
router.post("/packageDelete/:id", packageDelete);
router.post("/deleteCaption/:id", deleteCaptionData);
router.post("/deleteImaginationImage/:id", deleteImaginationImage);
router.get(
  "/allArticleTableData/:pageNo/:perPage/:searchKeyword",
  emailVerify,
  allArticleTableData
);
router.post("/webScripting", deCodeEmail, WebScripting);

// Payment routes
router.post("/pay", payProduct);
router.post("/payment-checkout-stripe", stripeMethod);
router.get("/stripeUserData", emailVerify, stripeUserData);
router.get(
  "/getStripeAdminAllData/:pageNo/:perPage/:searchKeyword",
  getStripeAdminAllData
);

router.post("/createOpenAPI", createOpenAPI);
router.get("/getOpenAPIAdmin", getOpenAPIAdmin);
router.post("/createStripeData", createStripeData);
router.get("/getStripeDataAdmin", getStripeDataAdmin);
router.post("/createPaypalData", createPaypalData);
router.get("/getPaypalDataAdmin", getPaypalDataAdmin);
router.post("/createGoogleClientKey", createGoogleClientKey);

// Speech to Text and Audio routes
router.post(
  "/speechToText",
  uploadAudio.single("audio"),
  deCodeEmail,
  SpeechToText
);
router.post(
  "/audioEditFile",
  EditAudioUP.single("audio"),
  deCodeEmail,
  editAudioFile
);
router.get(
  "/allEditAudio/:pageNo/:perPage/:searchKeyword",
  emailVerify,
  allEditAudio
);
router.get("/AllFileAudioText", emailVerify, AllFileAudioText);

router.post("/aiReWriter", deCodeEmail, aiReWriter);

// AI routes
router.post("/AICodeGenerate", deCodeEmail, AICodeGenerate);
router.post(
  "/AIScratchCodeGenerate",
  scratchImageUpload.single("image"),
  deCodeEmail,
  AIScratchCodeGenerate
);
router.get(
  "/AiCodeList/:pageNo/:perPage/:searchKeyword",
  emailVerify,
  AiCodeList
);
router.get(
  "/aiScratchCodeList/:pageNo/:perPage/:searchKeyword",
  emailVerify,
  aiScratchCodeList
);

// Image routes
router.post("/ImageController", deCodeEmail, ImageController);
router.get(
  "/AllImageTableData/:pageNo/:perPage/:searchKeyword",
  emailVerify,
  AllImageTableData
);
router.get("/imagCountUserDashboard", emailVerify, imagCountUserDashboard);
router.post("/deleteImage/:id", deleteImage);
router.get("/AiImageListHomepage", AiImageListHomepage);
router.get("/AiImageList", emailVerify, AiImageList);

// Text centennial
router.post("/fixErrorTextReq", deCodeEmail, fixErrorTextReq);
router.post("/autoCheckTextValue", deCodeEmail, autoCheckTextValue);
router.post("/contentDetect", deCodeEmail, detectContent);
router.post("/plagiarismChecker", deCodeEmail, PlagiarismChecker);
router.post("/paraphrase", deCodeEmail, Paraphraser);

// File reading routes
router.get("/findEditAudio", findEditAudioFiles);
router.get("/uploads", readUploadedFiles);
router.get("/chatImage", readChatImage);
router.get("/ImaginationFile", readImaginationImage);
router.get("/captionImage", readCaptionImage);
router.get("/findAudio", findAudioFiles);
router.get("/Blog_image", readBlogImages);
router.get("/findImageToAudio", findImageToAudioFile);

// Authentication and User routes
router.post("/googleLogin", googleVerify, googleLogin);
router.post("/AuthRegistration", authRegistration);
router.post("/AuthLogin", authLogin);
router.post("/AuthUpdate", emailVerify, authUpdate);
router.post("/deleteUser/:id", deleteUser);
router.get("/freeUserAdmin", freeUserCountAdmin);
router.get("/paidUserAdmin", paidUserCountAdmin);
router.get("/allConsumeDataAdmin", allConsumeDataAdmin);
router.get("/spendMonyCountForMarketing", spendMonyCountForMarketingAdmin);
router.get("/totalLimit", totalLimit);
router.post("/VerifyEmail", verifyEmail);
router.get("/RecoverVerifyOtp/:email/:OTP", recoverVerifyOTP);
router.post("/RecoverRestPassword", recoverRestPassword);
router.get("/getUserDetails", emailVerify, getUserDetails);
router.get("/imaginationImageData", emailVerify, imaginationImageData);
router.get("/captionImageData", emailVerify, captionImageData);
router.get(
  "/captionDataList/:pageNo/:perPage/:searchKeyword",
  emailVerify,
  captionImageDataList
);
router.get("/getAllUser/:pageNo/:perPage/:searchKeyword", getAllUserList);
router.get(
  "/totalPaidUserList/:pageNo/:perPage/:searchKeyword",
  totalPaidUserList
);
router.post("/Affiliate/:id", affiliateSubscription);
router.post("/saveAffiliateData", SaveAffiliateData);
router.get("/getAffiliateData", getAffiliateData);
router.post("/deleteAccount", emailVerify, deleteAccount);
router.post("/sendMassage", contactForm);
router.post(
  "/youTubeAnalyser",
  downloadYouTubeVideo,
  deCodeEmail,
  aiYouTubeController
);
router.get(
  "/youTubeAnalysesCount",
  emailVerify,
  youTubeAnalysesCountUserDashboard
);
router.get(
  "/allYouTubeTableData/:pageNo/:perPage/:searchKeyword",
  emailVerify,
  allYouTubeTableData
);

// Package routes
router.post("/createPackage", createPackage);
router.post("/updatePackage", updatePackage);
router.get("/createPackageList", createPackageList);
router.get("/readPackageListAdmin", createPackageListAdmin);
router.post("/editPackage", editPackageDataGet);
router.post("/packageDelete/:id", packageDelete);
router.post("/showHidePackage", showHidePackage);
router.post("/orderPackage/:selectedPlanId", orderPackage);

// AI template create admin routes
router.post("/createTemplate", createTemplate);
router.get(
  "/templateListAdmin/:pageNo/:perPage/:searchKeyword",
  templateListAdmin
);
router.post("/showHideTemplate", showHideTemplate);
router.post("/updateTemplate", updateTemplateData);
router.post("/deleteTemplate/:id", deleteTemplate);

// AI template create user routes
router.get("/getAllTemplateUser", getAllTemplateUser);
router.post("/getSingleData/:id", getSingleTemplateData);
router.post("/favoriteData", setFavoriteData);
router.get("/allFavoriteTemplate", getAllFavoriteTemplate);

// AI Chat Assistant routes
router.post("/createAssistant", createAssistant);
router.get(
  "/assistantListAdmin/:pageNo/:perPage/:searchKeyword",
  assistantListAdmin
);
router.post("/updateAssistantPosition", updateAssistantPositionInDB);
router.post("/showHideFaq", showHideFaq);
router.post("/showHideAssistant", showHideAssistant);
router.post("/showHideSocialMedia", showHideSocialMedia);

router.post("/getEditAssistantAdvanceModel", getEditAssistantAdvanceModel);
router.post("/updateAssistant", updateAssistantData);
router.post("/deleteAssistant/:id", deleteAssistant);
router.post("/deleteFaqData/:id", deleteFaqData);
router.post("/deleteSocialMedia/:id", deleteSocialMedia);

router.post("/chatWithOpenAI", deCodeEmail, chatWithOpenAI);
router.post("/aiUserChatImage", deCodeEmail, userChatImage);
router.post("/createAssistantAdvanceSetting", createAssistantAdvanceSetting);
router.post("/updateAssistantSettingModel", updateAssistantSettingModel);
router.get("/getAllAssistantUser", getAllAssistantUser);

router.get("/premiumAssistantListAdmin", premiumAssistantListAdmin);
router.get("/vipAssistantListAdmin", vipAssistantListAdmin);
router.get(
  "/allAssistantTableUserData/:pageNo/:perPage/:searchKeyword",
  emailVerify,
  allAssistantTableUserData
);
router.get(
  "/allImageAssistantTable/:pageNo/:perPage/:searchKeyword",
  emailVerify,
  allImageAssistantTableData
);
router.get("/getAllImageChatData", getAllImageChatAssistantData);
router.post("/getAssistantSingleData/:id", getSingleAssistantData);
router.post("/favoriteAssistantData", setFavoriteAssistantData);
router.get("/getAllFavorite", getAllFavoriteAssistant);
// chat image API
router.post("/createChatImageAgent", createChatImageAgent);
router.post("/deleteChatImageAgent/:id", deleteChatImageAgent);
router.post("/editImageChatAgentTitle", updateChatImageAgent);

// Bling Information routes
router.post("/createBling", BlingInformationData);
router.get("/orderList/:pageNo/:perPage/:searchKeyword", orderList);
router.get("/totalOrder", TotalOrderCount);
router.get("/getOrderNotify", getOrderNotify);
router.post("/deleteOrder/:id", deleteOrder);
router.get("/sentOrderId", sentOrderId);
router.post("/totalPrice/:id", totalPrice);
router.post("/updateConformData", updateConformData);
router.post(
  "/videoToText",
  videoToText.single("video"),
  deCodeEmail,
  videoToTextController
);
router.get("/visionCountUserDashboard", emailVerify, visionCountUserDashboard);
router.get(
  "/allVisionTableData/:pageNo/:perPage/:searchKeyword",
  emailVerify,
  allVisionTableData
);
router.post(
  "/visionApi",
  visionImageUpload.single("image"),
  deCodeEmail,
  visionImage
);
router.post(
  "/imageToAudio",
  imageToAudioFileUpload.single("image"),
  deCodeEmail,
  imageToAudioCreate
);
router.post(
  "/imaginationImageMake",
  imaginationImageFileUpload.single("image"),
  deCodeEmail,
  ImaginationImage
);
router.post(
  "/imageCaptionMake",
  imageCaptionFileUpload.single("image"),
  deCodeEmail,
  imageCaptionGenerate
);
router.get(
  "/imageToAudioTable/:pageNo/:perPage/:searchKeyword",
  emailVerify,
  imageToAudioTableData
);
router.get("/getSmtpData", getSmtpInfo);
router.post("/createSmtpInfo", createOrUpdateSmtpInfo);
router.post("/faqDataCreate", createFaqInfo);
router.get("/getFaqDataUser", getFaqInfoUser);
router.get("/getFaqDataAdmin", getFaqInfoAdmin);
router.post("/updateFaqAdmin", updateFaqAdmin);
router.post("/socialMediaCreate", socialMediaCreate);
router.post("/updateSocialMediaAdmin", updateSocialMediaAdmin);
router.get("/getAllSocialMedia", getAllSocialMedia);
router.get(
  "/readSocialMediaAdmin/:pageNo/:perPage/:searchKeyword",
  readSocialMediaAdmin
);
// Blog routes
router.post(
  "/crateBlog",
  blogImageUpload.fields([
    { name: "thumbnail", maxCount: 1 },
    { name: "coverImage", maxCount: 1 },
  ]),
  createBlog
);
router.post(
  "/updateBlogData",
  blogImageUpload.fields([
    { name: "thumbnail", maxCount: 1 },
    { name: "coverImage", maxCount: 1 },
  ]),
  updateBlogData
);
router.get("/blogList/:pageNo/:perPage/:searchKeyword", blogList);
router.post("/readBlog", readBlogDataAll);
router.post("/deleteBlog/:id", deleteBlog);
router.post("/showHideBlog", showHideBlog);
router.post("/editBlog", editBlogData);
module.exports = router;

function readImaginationImage(req, res) {
  readFiles(req, res, "../AllFile/CaptionImage", [
    ".jpg",
    ".jpeg",
    ".png",
    ".gif",
  ]);
}
function readCaptionImage(req, res) {
  readFiles(req, res, "../AllFile/CaptionImage", [
    ".jpg",
    ".jpeg",
    ".png",
    ".gif",
  ]);
}

function readUploadedFiles(req, res) {
  readFiles(req, res, "../AllFile/Upload-image", [
    ".jpg",
    ".jpeg",
    ".png",
    ".gif",
  ]);
}

function readChatImage(req, res) {
  readFiles(req, res, "../AllFile/ChatImage", [
    ".jpg",
    ".jpeg",
    ".png",
    ".gif",
  ]);
}
function findEditAudioFiles(req, res) {
  readFiles(req, res, "../AllFile/EditAudioFile", [".mp3"]);
}

function findAudioFiles(req, res) {
  readFiles(req, res, "../AllFile/TextToAudioFile", [".mp3"]);
}
function findImageToAudioFile(req, res) {
  readFiles(req, res, "../AllFile/ImageToAudofileStore", [".mp3"]);
}

function readBlogImages(req, res) {
  readFiles(req, res, "../AllFile/Blog_image", [
    ".jpg",
    ".jpeg",
    ".png",
    ".gif",
  ]);
}
function readCaptionImage(req, res) {
  readFiles(req, res, "../AllFile/CaptionImages", [
    ".jpg",
    ".jpeg",
    ".png",
    ".gif",
  ]);
}
function readFiles(req, res, directoryPath, allowedExtensions) {
  try {
    const fullPath = path.join(__dirname, directoryPath);
    fs.readdir(fullPath, function (err, files) {
      if (err) {
        return res.status(500).send({ error: "Error reading directory." });
      }
      const filteredFiles = files
        .filter((file) =>
          allowedExtensions.includes(path.extname(file).toLowerCase())
        )
        .map((file) => `${file}`);
      res.status(200).json(filteredFiles);
    });
  } catch (err) {
    console.error(err);
    res.status(500).json({ error: "Error finding data" });
  }
}
