// const fetch = require("node-fetch");
// const { PAYPAL_CLIENT_ID, PAYPAL_CLIENT_SECRET } = process.env;
// const base = "https://api-m.sandbox.paypal.com";

// async function generateAccessToken() {
//   try {
//     if (!PAYPAL_CLIENT_ID || !PAYPAL_CLIENT_SECRET) {
//       throw new Error("MISSING_API_CREDENTIALS");
//     }
//     const auth = Buffer.from(
//       `${PAYPAL_CLIENT_ID}:${PAYPAL_CLIENT_SECRET}`
//     ).toString("base64");
//     const response = await fetch(`${base}/v1/oauth2/token`, {
//       method: "POST",
//       body: "grant_type=client_credentials",
//       headers: {
//         Authorization: `Basic ${auth}`,
//       },
//     });
//     const data = await response.json();
//     return data.access_token;
//   } catch (error) {
//     console.error("Failed to generate Access Token:", error);
//     throw error;
//   }
// }

// async function handleResponse(response) {
//   try {
//     const jsonResponse = await response.json();
//     return {
//       jsonResponse,
//       httpStatusCode: response.status,
//     };
//   } catch (err) {
//     const errorMessage = await response.text();
//     throw new Error(errorMessage);
//   }
// }

// async function createOrder(data) {
//   try {
//     const accessToken = await generateAccessToken();
//     const url = `${base}/v2/checkout/orders`;
//     const orderAmount = parseFloat(data.product.cost || 0);
//     const response = await fetch(url, {
//       method: "POST",
//       headers: {
//         "Content-Type": "application/json",
//         Authorization: `Bearer ${accessToken}`,
//       },
//       body: JSON.stringify({
//         intent: "CAPTURE",
//         purchase_units: [
//           {
//             amount: {
//               currency_code: "USD",
//               value: orderAmount,
//             },
//           },
//         ],
//       }),
//     });

//     return handleResponse(response);
//   } catch (error) {
//     console.error("Error creating order:", error);
//     throw error;
//   }
// }

// async function capturePayment(orderID) {
//   try {
//     const accessToken = await generateAccessToken();
//     const url = `${base}/v2/checkout/orders/${orderID}/capture`;

//     const response = await fetch(url, {
//       method: "POST",
//       headers: {
//         "Content-Type": "application/json",
//         Authorization: `Bearer ${accessToken}`,
//       },
//     });

//     return handleResponse(response);
//   } catch (error) {
//     console.error("Error capturing payment:", error);
//     throw error;
//   }
// }

// module.exports = { createOrder, capturePayment };

const axios = require('axios');
const { PAYPAL_CLIENT_ID, PAYPAL_CLIENT_SECRET } = process.env;
const base = "https://api-m.sandbox.paypal.com";

async function generateAccessToken() {
  try {
    if (!PAYPAL_CLIENT_ID || !PAYPAL_CLIENT_SECRET) {
      throw new Error("MISSING_API_CREDENTIALS");
    }
    const auth = Buffer.from(`${PAYPAL_CLIENT_ID}:${PAYPAL_CLIENT_SECRET}`).toString("base64");

    const response = await axios.post(`${base}/v1/oauth2/token`, "grant_type=client_credentials", {
      headers: {
        Authorization: `Basic ${auth}`,
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    });

    return response.data.access_token;
  } catch (error) {
    console.error("Failed to generate Access Token:", error);
    throw error;
  }
}

async function handleResponse(response) {
  try {
    return {
      jsonResponse: response.data,
      httpStatusCode: response.status,
    };
  } catch (err) {
    throw new Error(response.statusText);
  }
}

async function createOrder(data) {
  try {
    const accessToken = await generateAccessToken();
    const url = `${base}/v2/checkout/orders`;
    const orderAmount = parseFloat(data.product.cost || 0);

    const response = await axios.post(url, {
      intent: "CAPTURE",
      purchase_units: [
        {
          amount: {
            currency_code: "USD",
            value: orderAmount,
          },
        },
      ],
    }, {
      headers: {
        "Content-Type": "application/json",
        Authorization: `Bearer ${accessToken}`,
      },
    });

    return handleResponse(response);
  } catch (error) {
    console.error("Error creating order:", error);
    throw error;
  }
}

async function capturePayment(orderID) {
  try {
    const accessToken = await generateAccessToken();
    const url = `${base}/v2/checkout/orders/${orderID}/capture`;

    const response = await axios.post(url, {}, {
      headers: {
        "Content-Type": "application/json",
        Authorization: `Bearer ${accessToken}`,
      },
    });

    return handleResponse(response);
  } catch (error) {
    console.error("Error capturing payment:", error);
    throw error;
  }
}

module.exports = { createOrder, capturePayment };
